/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class SocketUtils {
    private static final Logger logger = Logger.getLogger((String)SocketUtils.class.getName());

    public static boolean closeServerSocket(ServerSocket serverSocket) {
        boolean closed = true;
        try {
            try {
                if (serverSocket != null && !serverSocket.isClosed()) {
                    serverSocket.close();
                    serverSocket = null;
                }
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to close the server socket.", (Throwable)e);
                closed = false;
                try {
                    if (serverSocket != null && !serverSocket.isClosed()) {
                        serverSocket.close();
                        serverSocket = null;
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)"IOException occured by trying to close the server socket.", (Throwable)e2);
                    closed = false;
                }
            }
        }
        finally {
            try {
                if (serverSocket != null && !serverSocket.isClosed()) {
                    serverSocket.close();
                    serverSocket = null;
                }
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to close the server socket.", (Throwable)e);
                closed = false;
            }
        }
        return closed;
    }

    public static Object readObject(InetAddress inetAddress, int port) throws IOException, ClassNotFoundException {
        return SocketUtils.readObject(new Socket(inetAddress, port));
    }

    public static Object readObject(Socket clientSocket) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        Object objectToReturn = null;
        try {
            try {
                in = new ObjectInputStream(new BufferedInputStream(clientSocket.getInputStream()));
                while ((objectToReturn = in.readObject()) == null) {
                }
                in.close();
                clientSocket.close();
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to read the object.", (Throwable)e);
                throw e;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"ClassNotFoundException occured by trying to read the object from the socket.", (Throwable)e);
                throw e;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to close the socket.", (Throwable)e);
                throw e;
            }
        }
        return objectToReturn;
    }

    public static Object readObject(String serverName, int port) throws IOException, ClassNotFoundException {
        InetAddress inetAddress = InetAddress.getByName(serverName);
        return SocketUtils.readObject(new Socket(inetAddress, port));
    }

    public static void writeObject(InetAddress inetAddress, int port, Object objectToSend) throws IOException {
        Socket socketToClient = null;
        ObjectOutputStream oos = null;
        try {
            try {
                socketToClient = new Socket(inetAddress, port);
                oos = new ObjectOutputStream(new BufferedOutputStream(socketToClient.getOutputStream()));
                oos.writeObject(objectToSend);
                oos.close();
                socketToClient.close();
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to write the object.", (Throwable)e);
                throw e;
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (socketToClient != null) {
                    socketToClient.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"IOException occured by trying to close the socket.", (Throwable)e);
                throw e;
            }
        }
    }

    public static void writeObject(Socket socket, int port, Object objectToSend) throws IOException {
        SocketUtils.writeObject(socket.getInetAddress(), port, objectToSend);
    }

    public static void writeObject(String serverName, int port, Object objectToSend) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(serverName);
        SocketUtils.writeObject(inetAddress, port, objectToSend);
    }
}

