/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import net.sourceforge.jaulp.net.SocketUtils;

public class GetIP {
    public static String getIP(InetAddress inetAddress) {
        String ip = "";
        ip = inetAddress.getHostAddress();
        if (ip.equals("")) {
            byte[] ipAddressInBytes = inetAddress.getAddress();
            int i = 0;
            while (i < ipAddressInBytes.length) {
                if (i > 0) {
                    ip = String.valueOf(ip) + ".";
                }
                ip = String.valueOf(ip) + (ipAddressInBytes[i] & 0xFF);
                ++i;
            }
        }
        return ip;
    }

    public static byte[] getIPAsByte(InetAddress inetAddress) {
        return inetAddress.getAddress();
    }

    public static String getLocalIP() throws UnknownHostException {
        return GetIP.getIP(InetAddress.getLocalHost());
    }

    public static byte[] getLocalIPAsByte() {
        byte[] ipAddressInBytes = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            ipAddressInBytes = inetAddress.getAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ipAddressInBytes;
    }

    public static InetAddress getLocalIPFromServerSocket(int port, int backlog) {
        InetAddress inetAddress;
        block6: {
            inetAddress = null;
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(port, backlog, InetAddress.getLocalHost());
                inetAddress = socket.getInetAddress();
                socket.close();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                SocketUtils.closeServerSocket(socket);
                break block6;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SocketUtils.closeServerSocket(socket);
                    throw throwable;
                }
                SocketUtils.closeServerSocket(socket);
                break block6;
            }
            SocketUtils.closeServerSocket(socket);
        }
        return inetAddress;
    }

    public static String getLocalIPFromServerSocketAsString() {
        InetAddress inetAddress = null;
        inetAddress = GetIP.getLocalIPFromServerSocket(10000, 20000);
        return GetIP.getIP(inetAddress);
    }
}

