/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import net.sourceforge.jaulp.net.SocketUtils;

public class GetIP {
    public static String getIP(InetAddress inetAddress) {
        String ip = "";
        ip = inetAddress.getHostAddress();
        if (ip.equals("")) {
            byte[] ipAddressInBytes = inetAddress.getAddress();
            for (int i = 0; i < ipAddressInBytes.length; ++i) {
                if (i > 0) {
                    ip = ip + ".";
                }
                ip = ip + (ipAddressInBytes[i] & 0xFF);
            }
        }
        return ip;
    }

    public static byte[] getIPAsByte(InetAddress inetAddress) {
        return inetAddress.getAddress();
    }

    public static String getLocalIP() throws UnknownHostException {
        return GetIP.getIP(InetAddress.getLocalHost());
    }

    public static byte[] getLocalIPAsByte() throws UnknownHostException {
        return InetAddress.getLocalHost().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalIPFromServerSocket(int port, int backlog) throws UnknownHostException, IOException {
        InetAddress inetAddress = null;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, backlog, InetAddress.getLocalHost());
            inetAddress = socket.getInetAddress();
            socket.close();
        }
        catch (Throwable throwable) {
            SocketUtils.closeServerSocket(socket);
            throw throwable;
        }
        SocketUtils.closeServerSocket(socket);
        return inetAddress;
    }

    public static String getLocalIPFromServerSocketAsString() throws UnknownHostException, IOException {
        InetAddress inetAddress = null;
        inetAddress = GetIP.getLocalIPFromServerSocket(10000, 20000);
        return GetIP.getIP(inetAddress);
    }
}

