/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityUtils {
    public static final String VELOCITY_TEMPLATE_FILE_EXTENSION = ".vm";

    public static VelocityEngine getClasspathResourceLoaderVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    public static Template getTemplate(String templateAsString) throws ParseException {
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        StringReader reader = new StringReader(templateAsString);
        SimpleNode node = runtimeServices.parse((Reader)reader, "Template name");
        Template template = new Template();
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)node);
        template.initDocument();
        template.setEncoding("UTF-8");
        return template;
    }

    public static Template getTemplate(VelocityEngine ve, String path, String templateName) {
        return VelocityUtils.getTemplate(ve, path, templateName, "UTF-8");
    }

    public static Template getTemplate(VelocityEngine ve, String path, String templateName, String encoding) {
        String templatePath = path + templateName + VELOCITY_TEMPLATE_FILE_EXTENSION;
        Template template = ve.getTemplate(templatePath, encoding);
        return template;
    }

    public static String merge(VelocityContext context, String templateAsString) {
        return VelocityUtils.merge(context, "VelocityUtilsMergeMethod", templateAsString);
    }

    public static String merge(VelocityContext context, String logTag, String templateAsString) {
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)writer, (String)logTag, (String)templateAsString);
        return writer.toString();
    }
}

