/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.string;

public class StringExtensions {
    private static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String addDoubleQuotationMarks(String s) {
        return "\"" + s + "\"";
    }

    public static final String addSingleQuotationMarks(String s) {
        return "'" + s + "'";
    }

    public static final String firstCharacterToLowerCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toLowerCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static final String firstCharacterToUpperCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static final boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isNumber(String testString) {
        if (null == testString) {
            return false;
        }
        for (int i = 0; i < testString.length(); ++i) {
            if (Character.isDigit(testString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String lastCharacter(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return str.substring(str.length() - 1);
    }

    public static final String removeQuotationMarks(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static final String replaceLast(String original, String findString, String replacement) {
        int index = original.lastIndexOf(findString);
        if (index == -1) {
            return original;
        }
        StringBuffer originalFiltered = new StringBuffer();
        originalFiltered.append(original.substring(0, index));
        originalFiltered.append(replacement);
        originalFiltered.append(original.substring(index + findString.length()));
        String result = originalFiltered.toString().trim();
        return result;
    }

    private static char toHex(int i) {
        return HEXADECIMAL_DIGITS[i & 0xF];
    }

    public static String toUnicode(String toUnicode, boolean toLowerCase) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toUnicode.length(); ++i) {
            String hex = Integer.toHexString(toUnicode.codePointAt(i));
            hex = toLowerCase ? hex.toLowerCase() : hex.toUpperCase();
            String hexWithZeros = "0000" + hex;
            String hexCodeWithLeadingZeros = hexWithZeros.substring(hexWithZeros.length() - 4);
            sb.append("\\u" + hexCodeWithLeadingZeros);
        }
        return sb.toString();
    }

    public static String toUnicodeChars(String s, boolean toLowerCase) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int length = s.length();
        int sbLength = length * 2;
        StringBuilder sb = new StringBuilder(sbLength);
        block8: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                case ' ': {
                    if (i == 0) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(StringExtensions.toHex(c >> 12 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 8 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 4 & 0xF));
                        sb.append(StringExtensions.toHex(c & 0xF));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        String returnString = sb.toString();
        if (toLowerCase) {
            return returnString.toLowerCase();
        }
        return returnString;
    }
}

