/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.locale;

import de.alpharogroup.lang.ClassExtensions;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleUtils {
    public static String getString(ResourceBundle resourceBundle, String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "Warning:Missing key is '" + key + "'";
        }
    }

    public static String getString(ResourceBundle resourceBundle, String key, Object ... params) {
        try {
            return MessageFormat.format(resourceBundle.getString(key), params);
        }
        catch (MissingResourceException e) {
            return "Warning:Missing key is '" + key + "'";
        }
    }

    public static String getString(String baseName, Locale locale, String key, Object ... params) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
        return ResourceBundleUtils.getString(resourceBundle, key, params);
    }

    public static <T> String newResourceKey(T object, String keySuffix) {
        return ClassExtensions.getSimpleName(object.getClass()) + '.' + keySuffix;
    }
}

