/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.locale;

import de.alpharogroup.file.FilenameUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class LocaleUtils {
    public static final String[] COUNTRY_CODES = Locale.getISOCountries();
    public static final String[] LANGUAGE_CODES = Locale.getISOLanguages();

    public static Locale getLocale(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        String[] splitted = code.split("_");
        if (splitted.length == 1) {
            return new Locale(code);
        }
        if (splitted.length == 2) {
            return new Locale(splitted[0], splitted[1]);
        }
        if (splitted.length == 3) {
            return new Locale(splitted[0], splitted[1], splitted[2]);
        }
        return null;
    }

    public static String getLocaleCode(File propertiesFile) {
        String filename = FilenameUtils.getFilenameWithoutExtension(propertiesFile);
        int underscoreIndex = filename.indexOf("_");
        String stringCode = "default";
        if (0 < underscoreIndex) {
            stringCode = filename.substring(underscoreIndex + 1, filename.length());
        }
        return stringCode;
    }

    public static String getLocaleFilenameSuffix(Locale locale) {
        return LocaleUtils.getLocaleFileSuffix(locale, true, true, false);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry) {
        return LocaleUtils.getLocaleFileSuffix(locale, withCountry, false);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry, boolean withVariant) {
        return LocaleUtils.getLocaleFileSuffix(locale, withCountry, withVariant, true);
    }

    public static String getLocaleFileSuffix(Locale locale, boolean withCountry, boolean withVariant, boolean withUnderscorePrefix) {
        StringBuilder localizedName = new StringBuilder();
        if (locale != null) {
            if (locale.getLanguage() != null && !locale.getLanguage().isEmpty()) {
                if (withUnderscorePrefix) {
                    localizedName.append("_");
                }
                localizedName.append(locale.getLanguage());
            }
            if (withCountry && locale.getCountry() != null && !locale.getCountry().isEmpty()) {
                localizedName.append("_");
                localizedName.append(locale.getCountry());
            }
            if (withVariant && locale.getVariant() != null && !locale.getVariant().isEmpty()) {
                localizedName.append("_");
                localizedName.append(locale.getVariant());
            }
        }
        return localizedName.toString().trim();
    }

    @Deprecated
    public static String getLocaleName(Locale locale) {
        return LocaleUtils.getLocaleFileSuffix(locale, true, true, false);
    }

    public static boolean isISOCountryCode(String code) {
        if (code.length() == 2) {
            code = code.toUpperCase();
            List<String> lc = Arrays.asList(COUNTRY_CODES);
            return lc.contains(code);
        }
        return false;
    }
}

