/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.file.FileExtension;
import de.alpharogroup.file.namefilter.ResourceBundleFilenameFilter;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.PackageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public final class PropertiesUtils {
    public static final String SEARCH_FILE_PATTERN = "([^\\s]+(\\.(?i)(java|html|htm))$)";
    public static final String[] PROPERTIES_DELIMITERS = new String[]{"=", ":", " "};
    private static final Logger LOGGER = Logger.getLogger(PropertiesUtils.class.getName());

    public static Map<String, List<String>> findRedundantValues(Properties properties) {
        List keys;
        LinkedHashMap reverseEntries = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!reverseEntries.containsKey(value)) {
                keys = new ArrayList<String>();
                keys.add(key);
                reverseEntries.put(value, keys);
                continue;
            }
            keys = (List)reverseEntries.get(value);
            keys.add(key);
        }
        LinkedHashMap<String, List<String>> redundantValues = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : reverseEntries.entrySet()) {
            String key = (String)entry.getKey();
            keys = (List)entry.getValue();
            if (1 >= keys.size()) continue;
            redundantValues.put(key, keys);
        }
        return redundantValues;
    }

    public static Set<String> getAvailableLanguages(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new ResourceBundleFilenameFilter(bundlename));
        TreeSet<String> languages = new TreeSet<String>();
        for (File file : files) {
            languages.add(file.getName().replaceAll("^" + bundlename + "(_)?|\\.properties$", ""));
        }
        return languages;
    }

    public static String getBundlename(File propertiesFile) {
        String filename = propertiesFile.getName();
        int indexOfUnderscore = filename.indexOf("_");
        String bundlename = filename;
        if (0 < indexOfUnderscore) {
            bundlename = propertiesFile.getName().substring(0, filename.indexOf("_"));
        }
        return bundlename;
    }

    public static Locale getLocale(File propertiesFile) {
        String[] splitted;
        String localeString = propertiesFile.getName().replaceAll("^" + PropertiesUtils.getBundlename(propertiesFile) + "(_)?|\\.properties$", "");
        Locale current = null;
        current = localeString != null && !localeString.isEmpty() ? (1 < (splitted = localeString.split("_")).length ? new Locale(splitted[0], splitted[1]) : new Locale(localeString)) : Locale.getDefault();
        return current;
    }

    public static Map<File, Locale> getLocales(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new ResourceBundleFilenameFilter(bundlename));
        HashMap<File, Locale> locales = new HashMap<File, Locale>();
        for (File file : files) {
            Locale current = PropertiesUtils.getLocale(file);
            locales.put(file, current);
        }
        return locales;
    }

    public static Properties getLocalPropertiesFromClass(Class<?> componentClass, Class<?> defaultClass, Locale locale) throws Exception {
        Properties properties = null;
        properties = componentClass != null ? PropertiesUtils.loadPropertiesFromClassObject(componentClass, locale) : PropertiesUtils.loadPropertiesFromClassObject(defaultClass, locale);
        return properties;
    }

    public static Map<String, List<String>> getMatchedPrefixLists(Properties enProperties) {
        Enumeration<?> e = enProperties.propertyNames();
        LinkedHashMap<String, List<String>> matchedPrefixes = new LinkedHashMap<String, List<String>>();
        while (e.hasMoreElements()) {
            List<String> fullKeys;
            String key = (String)e.nextElement();
            int lastIndex = key.lastIndexOf(".");
            String subKey = null;
            subKey = 0 < lastIndex ? key.substring(0, lastIndex) : key;
            if (matchedPrefixes.containsKey(subKey)) {
                fullKeys = (List)matchedPrefixes.get(subKey);
                fullKeys.add(key);
                continue;
            }
            fullKeys = new ArrayList();
            fullKeys.add(key);
            matchedPrefixes.put(subKey, fullKeys);
        }
        return matchedPrefixes;
    }

    public static List<String> getPropertyParameters(String propertyValue) {
        ArrayList<String> parameterList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = pattern.matcher(propertyValue);
        while (matcher.find()) {
            String parameter = matcher.group();
            String at = parameter.substring(1, parameter.length() - 1);
            parameterList.add(at);
        }
        return parameterList;
    }

    public static Properties loadProperties(Class<?> clazz, String name) throws IOException {
        InputStream is;
        Properties properties = PropertiesUtils.loadProperties(name);
        if (properties == null && (is = ClassExtensions.getResourceAsStream(clazz.getClass(), name)) != null) {
            properties = new Properties();
            properties.load(is);
        }
        return properties;
    }

    public static Properties loadProperties(Class<?> clazz, String packagePath, String fileName) throws IOException {
        return PropertiesUtils.loadProperties(clazz, packagePath + fileName);
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = null;
        InputStream is = null;
        if (propertiesFile.exists()) {
            is = propertiesFile.toURI().toURL().openStream();
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        } else {
            throw new FileNotFoundException(propertiesFile.getName() + " not found.");
        }
        return properties;
    }

    public static Properties loadProperties(String packagePath) throws IOException {
        Properties properties = null;
        URL url = ClassExtensions.getResource(packagePath);
        if (url != null) {
            properties = new Properties();
            properties.load(url.openStream());
        } else {
            InputStream is = ClassExtensions.getResourceAsStream(packagePath);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        return properties;
    }

    public static Properties loadProperties(String packagePath, String fileName) throws IOException {
        StringBuilder sb = new StringBuilder();
        packagePath = FilenameUtils.normalize((String)packagePath);
        String slash = "/";
        if (packagePath.startsWith("/")) {
            if (packagePath.endsWith("/")) {
                sb.append(packagePath.substring(1, packagePath.length()));
            } else {
                sb.append(packagePath.substring(1, packagePath.length())).append("/");
            }
        } else if (packagePath.endsWith("/")) {
            sb.append(packagePath);
        } else {
            sb.append(packagePath).append("/");
        }
        packagePath = sb.toString().trim();
        sb = new StringBuilder();
        if (fileName.startsWith("/")) {
            sb.append(fileName.substring(1, fileName.length()));
        }
        fileName = sb.toString().trim();
        return PropertiesUtils.loadProperties(packagePath + fileName);
    }

    public static Properties loadPropertiesFromClassObject(Class<?> clazz, Locale locale) throws IOException {
        if (null == clazz) {
            throw new IllegalArgumentException("Class object must not be null!!!");
        }
        StringBuilder propertiesName = new StringBuilder();
        Properties properties = null;
        String language = null;
        String filename = null;
        String pathAndFilename = null;
        File propertiesFile = null;
        String absoluteFilename = null;
        String packagePath = PackageUtils.getPackagePathWithSlash(clazz);
        ArrayList<String> missedFiles = new ArrayList<String>();
        if (null != locale) {
            String country;
            propertiesName.append(clazz.getSimpleName());
            language = locale.getLanguage();
            if (null != language && !language.isEmpty()) {
                propertiesName.append("_").append(language);
            }
            if (null != (country = locale.getCountry()) && !country.isEmpty()) {
                propertiesName.append("_").append(country);
            }
            propertiesName.append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesUtils.loadProperties(pathAndFilename);
            } else {
                propertiesName = new StringBuilder();
                if (null != locale) {
                    propertiesName.append(clazz.getSimpleName());
                    language = locale.getLanguage();
                    if (null != language && !language.isEmpty()) {
                        propertiesName.append("_").append(language);
                    }
                    propertiesName.append(FileExtension.PROPERTIES.getExtension());
                    filename = propertiesName.toString().trim();
                    pathAndFilename = packagePath + filename;
                    url = ClassExtensions.getResource(clazz, filename);
                    if (url != null) {
                        absoluteFilename = url.getFile();
                    } else {
                        missedFiles.add("File with filename '" + filename + "' does not exists.");
                    }
                    if (null != absoluteFilename) {
                        propertiesFile = new File(absoluteFilename);
                    }
                    if (null != propertiesFile && propertiesFile.exists()) {
                        properties = PropertiesUtils.loadProperties(pathAndFilename);
                    }
                }
            }
        }
        if (null == properties) {
            propertiesName = new StringBuilder();
            propertiesName.append(clazz.getSimpleName()).append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                properties = PropertiesUtils.loadProperties(pathAndFilename);
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesUtils.loadProperties(pathAndFilename);
            }
        }
        if (properties == null) {
            for (String string : missedFiles) {
                LOGGER.info(string);
            }
        }
        return properties;
    }

    public static void toProperties(File properties, File xml, String comment) throws FileNotFoundException, IOException {
        PropertiesUtils.toProperties(new FileOutputStream(properties), new FileInputStream(xml), comment);
    }

    public static void toProperties(OutputStream properties, InputStream xml, String comment) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.loadFromXML(xml);
        prop.store(properties, comment);
    }

    public static void toXml(File properties, File xml, String comment, String encoding) throws FileNotFoundException, IOException {
        PropertiesUtils.toXml(new FileInputStream(properties), new FileOutputStream(xml), comment, encoding);
    }

    public static void toXml(InputStream properties, OutputStream xml, String comment, String encoding) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.load(properties);
        prop.storeToXML(xml, comment, encoding);
    }

    private PropertiesUtils() {
    }
}

