/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.io.ChangedAttributeResult;
import de.alpharogroup.io.SerializedObjectUtils;
import de.alpharogroup.reflection.ReflectionUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public final class ObjectExtensions {
    private static final Logger logger = Logger.getLogger((String)ObjectExtensions.class.getName());

    public static <T> T clone(T object) {
        return (T)ObjectExtensions.cloneObjectQuietly(object);
    }

    public static Object cloneObject(Object object) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        Object clone = null;
        if (object instanceof Serializable && (clone = SerializedObjectUtils.copySerializedObject((Serializable)object)) != null) {
            return clone;
        }
        if (clone == null && object instanceof Cloneable) {
            Class<?> clazz;
            Method cloneMethod;
            if (object.getClass().isArray()) {
                Class<?> componentType = object.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    int length = Array.getLength(object);
                    clone = Array.newInstance(componentType, length);
                    while (length-- > 0) {
                        Array.set(clone, length, Array.get(object, length));
                    }
                } else {
                    clone = ((Object[])object).clone();
                }
                if (clone != null) {
                    return clone;
                }
            }
            if ((clone = (cloneMethod = (clazz = object.getClass()).getMethod("clone", null)).invoke(object, (Object[])null)) != null) {
                return clone;
            }
        }
        if (clone == null) {
            clone = ReflectionUtils.getNewInstance(object);
            BeanUtils.copyProperties((Object)clone, (Object)object);
        }
        return clone;
    }

    public static Object cloneObjectQuietly(Object object) {
        Object clone = null;
        try {
            clone = ObjectExtensions.cloneObject(object);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: NoSuchMethodException", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: SecurityException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of IllegalAccessException. Could not found from ReflectionUtils.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: IllegalArgumentException", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of InvocationTargetException. Could not found from ReflectionUtils.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of ClassNotFoundException. Could not found from ReflectionUtils.", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of InstantiationException. Could not found from ReflectionUtils.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Try to clone the object with SerializedObjectUtils.copySerializedObject((Serializable)object) cause of IOException.", (Throwable)e);
        }
        return clone;
    }

    public static boolean compare(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        for (Object key : beanDescription.keySet()) {
            if (ObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            return false;
        }
        return true;
    }

    public static int compareTo(Object sourceOjbect, Object objectToCompare, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        Object sourceAttribute = beanDescription.get(property);
        Object changedAttribute = clonedBeanDescription.get(property);
        if (sourceAttribute == null && changedAttribute == null) {
            return 0;
        }
        if (sourceAttribute != null && changedAttribute == null) {
            return 1;
        }
        if (sourceAttribute == null && changedAttribute != null) {
            return -1;
        }
        return new BeanComparator(property).compare(sourceOjbect, objectToCompare);
    }

    public static int compareToQuietly(Object sourceOjbect, Object objectToCompare, String property) {
        Map beanDescription = null;
        try {
            beanDescription = BeanUtils.describe((Object)sourceOjbect);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error((Object)"BeanUtils.describe(sourceOjbect) throws an exception...", (Throwable)e);
            return 0;
        }
        beanDescription.remove("class");
        Map clonedBeanDescription = null;
        try {
            clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error((Object)"BeanUtils.describe(objectToCompare) throws an exception...", (Throwable)e);
            return 0;
        }
        clonedBeanDescription.remove("class");
        Object sourceAttribute = beanDescription.get(property);
        Object changedAttribute = clonedBeanDescription.get(property);
        if (sourceAttribute == null && changedAttribute == null) {
            return 0;
        }
        if (sourceAttribute != null && changedAttribute == null) {
            return 1;
        }
        if (sourceAttribute == null && changedAttribute != null) {
            return -1;
        }
        return new BeanComparator(property).compare(sourceOjbect, objectToCompare);
    }

    public static final <DESTINATION, ORIGINAL> void copy(DESTINATION destination, ORIGINAL original) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(destination, original);
    }

    public static final <DESTINATION, ORIGINAL> DESTINATION copyQuietly(DESTINATION destination, ORIGINAL original) {
        try {
            ObjectExtensions.copy(destination, original);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        return destination;
    }

    public static List<ChangedAttributeResult> getChangedData(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        ArrayList<ChangedAttributeResult> changedData = new ArrayList<ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            if (ObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.add(new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    public static Map<Object, ChangedAttributeResult> getChangedDataMap(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<Object, ChangedAttributeResult> changedData = new HashMap<Object, ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            if (ObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            changedData.put(key, new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    public static Map<String, Integer> getCompareToResult(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<String, Integer> compareResult = new HashMap<String, Integer>();
        for (Object key : beanDescription.keySet()) {
            compareResult.put(key.toString(), ObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()));
        }
        return compareResult;
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(DESTINATION destination, ORIGINAL original) {
        return ObjectExtensions.copyQuietly(destination, original) != null;
    }

    private ObjectExtensions() {
    }
}

