/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.file.FilenameUtils;
import de.alpharogroup.file.filter.ClassFileFilter;
import de.alpharogroup.lang.ClassExtensions;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class AnnotationUtils {
    public static Set<Class<?>> getAllAnnotatedClasses(String packagePath, Class<? extends Annotation> annotationClass) throws ClassNotFoundException, IOException {
        List<File> directories = ClassExtensions.getDirectoriesFromResources(packagePath, true);
        HashSet classes = new HashSet();
        for (File directory : directories) {
            classes.addAll(AnnotationUtils.scanForAnnotatedClasses(directory, packagePath, annotationClass));
        }
        return classes;
    }

    public static Set<Class<?>> getAllAnnotatedClassesFromSet(String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException, IOException {
        List<File> directories = ClassExtensions.getDirectoriesFromResources(packagePath, true);
        HashSet classes = new HashSet();
        for (File directory : directories) {
            classes.addAll(AnnotationUtils.scanForAnnotatedClassesFromSet(directory, packagePath, annotationClasses));
        }
        return classes;
    }

    public static Set<Class<?>> getAllClasses(String packagePath) throws ClassNotFoundException, IOException {
        return AnnotationUtils.getAllAnnotatedClasses(packagePath, null);
    }

    public static Set<Class<?>> getAllClasses(String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException, IOException {
        return AnnotationUtils.getAllAnnotatedClassesFromSet(packagePath, annotationClasses);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> componentClass, Class<T> annotationClass) {
        Class<?> superClass;
        T annotation = componentClass.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : componentClass.getInterfaces()) {
            annotation = AnnotationUtils.getAnnotation(ifc, annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        if (!Annotation.class.isAssignableFrom(componentClass)) {
            for (Annotation ann : componentClass.getAnnotations()) {
                annotation = AnnotationUtils.getAnnotation(ann.annotationType(), annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if ((superClass = componentClass.getSuperclass()) == null || superClass.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.getAnnotation(superClass, annotationClass);
    }

    public static boolean isAnnotationPresentInSuperClasses(Class<?> componentClass, Class<? extends Annotation> annotationClass) {
        if (componentClass.isAnnotationPresent(annotationClass)) {
            return true;
        }
        for (Class<?> superClass = componentClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresentInSuperClassesOrInterfaces(Class<?> componentClass, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotation(componentClass, annotationClass) != null;
    }

    public static Set<Class<?>> scanForAnnotatedClasses(File directory, String packagePath, Class<? extends Annotation> annotationClass) throws ClassNotFoundException {
        File[] files;
        HashSet foundClasses = new HashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory()) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(AnnotationUtils.scanForAnnotatedClasses(file, qualifiedClassname, annotationClass));
                continue;
            }
            String filename = FilenameUtils.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + '.' + filename;
            Class<?> foundClass = null;
            try {
                foundClass = Class.forName(qualifiedClassname);
                if (null != annotationClass) {
                    if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                    foundClasses.add(foundClass);
                    continue;
                }
                foundClasses.add(foundClass);
            }
            catch (Throwable throwable) {
                foundClass = Class.forName(qualifiedClassname, false, ClassExtensions.getClassLoader());
                if (null != annotationClass) {
                    if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                    foundClasses.add(foundClass);
                    continue;
                }
                foundClasses.add(foundClass);
            }
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanForAnnotatedClassesFromSet(File directory, String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException {
        File[] files;
        HashSet foundClasses = new HashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory()) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(AnnotationUtils.scanForAnnotatedClassesFromSet(file, qualifiedClassname, annotationClasses));
                continue;
            }
            String filename = FilenameUtils.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + '.' + filename;
            Class<?> foundClass = null;
            try {
                foundClass = Class.forName(qualifiedClassname);
                if (null != annotationClasses) {
                    for (Class<? extends Annotation> annotationClass : annotationClasses) {
                        if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                        foundClasses.add(foundClass);
                    }
                    continue;
                }
                foundClasses.add(foundClass);
            }
            catch (Throwable throwable) {
                foundClass = Class.forName(qualifiedClassname, false, ClassExtensions.getClassLoader());
                if (null != annotationClasses) {
                    for (Class<? extends Annotation> annotationClass : annotationClasses) {
                        if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                        foundClasses.add(foundClass);
                    }
                    continue;
                }
                foundClasses.add(foundClass);
            }
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanForClasses(File directory, String packagePath) throws ClassNotFoundException {
        return AnnotationUtils.scanForAnnotatedClasses(directory, packagePath, null);
    }

    private AnnotationUtils() {
    }
}

