/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import de.alpharogroup.string.StringUtils;
import java.io.OutputStream;
import java.io.Serializable;

public class StringOutputStream
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuilder stringBuilder = new StringBuilder();

    @Override
    public void close() {
        this.stringBuilder = null;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    @Override
    public void write(byte[] b) {
        this.stringBuilder.append(StringUtils.convertToCharArray(b));
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("StringOutputStream.write: index out of bounds.");
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = b[off];
            ++off;
        }
        this.stringBuilder.append(StringUtils.convertToCharArray(bytes));
    }

    @Override
    public void write(int b) {
        this.stringBuilder.append((char)b);
    }
}

