/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.iban;

import de.alpharogroup.collections.MapExtensions;
import de.alpharogroup.locale.LocaleUtils;
import de.alpharogroup.string.StringExtensions;
import de.alpharogroup.string.StringUtils;
import java.math.BigInteger;
import java.util.Map;

public class BankaccountUtils {
    static final String[][] REPLACE_CHAR_WITH_NUMBER = new String[][]{{"A", "10"}, {"B", "11"}, {"C", "12"}, {"D", "13"}, {"E", "14"}, {"F", "15"}, {"G", "16"}, {"H", "17"}, {"I", "18"}, {"J", "19"}, {"K", "20"}, {"L", "21"}, {"M", "22"}, {"N", "23"}, {"O", "24"}, {"P", "25"}, {"Q", "26"}, {"R", "27"}, {"S", "28"}, {"T", "29"}, {"U", "30"}, {"V", "31"}, {"W", "32"}, {"X", "33"}, {"Y", "34"}, {"Z", "35"}};

    public static boolean isIbanNumber(String ibanNumber) throws Exception {
        String ibanWOWS = ibanNumber;
        if ((ibanWOWS = StringUtils.replaceAll(ibanWOWS, " ", "")).length() > 34 || ibanWOWS.length() < 5) {
            return false;
        }
        String locale = ibanWOWS.substring(0, 2).toUpperCase();
        String checksum = ibanWOWS.substring(2, 4).toUpperCase();
        String bankAccountNumber = ibanWOWS.substring(4).toUpperCase();
        if (!StringExtensions.isNumber(checksum)) {
            return false;
        }
        if (!LocaleUtils.isISOCountryCode(locale)) {
            return false;
        }
        String adaptation = bankAccountNumber + BankaccountUtils.replaceCharsWithNumbers(locale) + "00";
        long cs = Long.valueOf(checksum);
        BigInteger bd = new BigInteger(adaptation);
        BigInteger ninetySeven = new BigInteger("97");
        int v = bd.mod(ninetySeven).intValue();
        int endsum = 98 - v;
        return (long)endsum == cs;
    }

    public static String replaceCharsWithNumbers(String locale) throws Exception {
        String retString = null;
        if (null != locale && locale.length() != 2) {
            throw new Exception("Invalide locale.");
        }
        String chr1 = locale.substring(0, 1);
        String chr2 = locale.substring(1, 2);
        Map map = MapExtensions.toGenericMap((Object[][])REPLACE_CHAR_WITH_NUMBER);
        String chr1Number = (String)map.get(chr1);
        String chr2Number = (String)map.get(chr2);
        retString = chr1Number + chr2Number;
        return retString;
    }
}

