/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sourceforge.jaulp.tree.ifaces.ITreeNode;

public class TreeNode<T>
implements ITreeNode<T> {
    private static final long serialVersionUID = 1L;
    private List<ITreeNode<T>> children;
    private ITreeNode<T> parent;
    private T value;
    private String displayValue;

    public TreeNode() {
    }

    public TreeNode(T value) {
        this();
        this.setValue(value);
    }

    @Override
    public void addChild(ITreeNode<T> child) {
        if (this.children != null) {
            this.children.add(child);
        } else {
            this.children = new ArrayList<ITreeNode<T>>();
            this.children.add(child);
        }
    }

    @Override
    public void addChildAt(int index, ITreeNode<T> child) throws IndexOutOfBoundsException {
        if (this.children != null && this.children.size() < index) {
            this.children.add(index, child);
        } else {
            this.addChild(child);
        }
    }

    @Override
    public boolean equals(ITreeNode<T> treeNode) {
        return treeNode.getValue().equals(treeNode);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public List<ITreeNode<T>> getChildren() {
        if (this.children == null) {
            return new ArrayList<ITreeNode<T>>();
        }
        return this.children;
    }

    @Override
    public ITreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren() != null && !this.getChildren().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean isLeaf() {
        return !this.isNode();
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return !this.hasParent();
    }

    @Override
    public void removeChild(ITreeNode<T> child) {
        if (this.children != null) {
            this.children.remove(child);
        } else {
            this.children = new ArrayList<ITreeNode<T>>();
        }
    }

    @Override
    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    @Override
    public void setChildren(List<ITreeNode<T>> children) {
        this.children = children;
    }

    @Override
    public void setParent(ITreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public List<ITreeNode<T>> toList() {
        ArrayList<ITreeNode<T>> list = new ArrayList<ITreeNode<T>>();
        this.traverse(this, list);
        return list;
    }

    @Override
    public void traverse(ITreeNode<T> node, List<ITreeNode<T>> list) {
        list.add(node);
        for (ITreeNode<T> data : node.getChildren()) {
            this.traverse(data, list);
        }
    }

    @Override
    public ITreeNode<T> getNextSibling() {
        ITreeNode<T> parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getChildren().indexOf(this) + 1;
        if (index == parent.getChildCount()) {
            return null;
        }
        return parent.getChildren().get(index);
    }

    @Override
    public ITreeNode<T> getPreviousSibling() {
        ITreeNode<T> parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getChildren().indexOf(this) - 1;
        if (index < 0) {
            return null;
        }
        return parent.getChildren().get(index);
    }

    @Override
    public List<ITreeNode<T>> getAllSiblings() {
        ITreeNode<T> parent = this.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<ITreeNode<T>> siblings = new ArrayList<ITreeNode<T>>(parent.getChildren());
        siblings.remove(this);
        return siblings;
    }

    @Override
    public int getLevel() {
        ITreeNode<T> current = this;
        int count = 0;
        while ((current = current.getParent()) != null) {
            ++count;
        }
        return count;
    }

    @Override
    public int getDepth() {
        if (this.isLeaf() || this.getChildCount() == 0) {
            return 0;
        }
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        ITreeNode<T> node = this.getChildren().get(0);
        int depth = 0;
        int current = 1;
        while (!stack.empty()) {
            int size;
            int index;
            if (node.getChildCount() != 0) {
                node = this.getChildren().get(0);
                stack.push(new Integer(0));
                ++current;
                continue;
            }
            if (current > depth) {
                depth = current;
            }
            do {
                node = node.getParent();
                size = node.getChildCount();
                index = (Integer)stack.pop() + 1;
                --current;
            } while (index >= size && node != this);
            if (index >= size) continue;
            node = this.getChildren().get(index);
            stack.push(new Integer(index));
            ++current;
        }
        return depth;
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }

    @Override
    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }
}

