/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.read;

import de.alpharogroup.io.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;

public final class ReadFileUtils {
    private static final Logger LOGGER = Logger.getLogger(ReadFileUtils.class.getName());

    public static Byte[] getFilecontentAsByteObjectArray(File tmpFile) {
        return ReadFileUtils.toObject(ReadFileUtils.toByteArray(tmpFile));
    }

    public static String inputStream2String(InputStream inputStream) {
        return ReadFileUtils.inputStream2String(inputStream, Charset.forName("UTF-8"));
    }

    public static String inputStream2String(InputStream inputStream, Charset encoding) {
        return ReadFileUtils.reader2String(new InputStreamReader(inputStream, encoding));
    }

    public static Reader openFileReader(String fileName) throws IOException {
        BufferedReader bufferedReader = null;
        File file = new File(fileName);
        bufferedReader = (BufferedReader)StreamUtils.getReader((File)file);
        return bufferedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader2String(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] charArray = new char[8192];
        try {
            int tmp;
            while ((tmp = reader.read(charArray)) > 0) {
                stringBuffer.append(charArray, 0, tmp);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "reader2String failed...\n" + e.getMessage(), e);
        }
        finally {
            StreamUtils.closeReader((Reader)reader);
        }
        return stringBuffer.toString();
    }

    public static byte[] readFileToBytearray(File file) {
        return ReadFileUtils.toByteArray(file);
    }

    public static String readFromFile(File file) throws IOException {
        return ReadFileUtils.inputStream2String(StreamUtils.getInputStream((File)file));
    }

    public static String readFromFile(File file, Charset encoding) throws IOException {
        return ReadFileUtils.inputStream2String(StreamUtils.getInputStream((File)file), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readHeadLine(String inputFile) {
        BufferedReader reader = null;
        String headLine = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            headLine = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, "readHeadLine failed...\n" + e.getMessage(), e);
            StreamUtils.closeReader((Reader)reader);
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, "readHeadLine failed...\n" + e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeReader(reader);
                    throw throwable;
                }
            }
            StreamUtils.closeReader((Reader)reader);
        }
        StreamUtils.closeReader((Reader)reader);
        return headLine;
    }

    public static List<String> readLinesInList(File input) throws FileNotFoundException, IOException {
        return ReadFileUtils.readLinesInList(new FileInputStream(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesInList(InputStream input) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            isr = new InputStreamReader(input);
            reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(isr);
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)isr);
        StreamUtils.closeReader((Reader)reader);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFromFile(String filename) {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            properties.load(fis);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.SEVERE, "readPropertiesFromFile failed...\n" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeInputStream(fis);
                throw throwable;
            }
            StreamUtils.closeInputStream((InputStream)fis);
        }
        StreamUtils.closeInputStream((InputStream)fis);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File tmpFile) {
        byte[] data = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        if (tmpFile.exists() && !tmpFile.isDirectory()) {
            try {
                bos = new ByteArrayOutputStream(1024);
                bis = new BufferedInputStream(new FileInputStream(tmpFile));
                StreamUtils.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos, (boolean)false);
                data = bos.toByteArray();
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "transformFilecontentToByteArray failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeInputStream(bis);
                    StreamUtils.closeOutputStream((OutputStream)bos);
                    throw throwable;
                }
                StreamUtils.closeInputStream((InputStream)bis);
                StreamUtils.closeOutputStream((OutputStream)bos);
            }
            StreamUtils.closeInputStream((InputStream)bis);
            StreamUtils.closeOutputStream((OutputStream)bos);
        }
        return data;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    private static Byte[] toObject(byte[] byteArray) {
        return ArrayUtils.toObject((byte[])byteArray);
    }

    private ReadFileUtils() {
    }
}

