/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sourceforge.jaulp.file.exceptions.FileDoesNotExistException;
import net.sourceforge.jaulp.file.search.FileSearchUtils;
import net.sourceforge.jaulp.file.zip.ZipModel;
import net.sourceforge.jaulp.io.StreamUtils;

public class Zipper
implements ZipModel {
    private ZipOutputStream zos = null;
    private long fileLength;
    private int fileCounter;
    private int zipLevel = -1;
    private int compressionMethod = -1;
    private String zipFileComment;
    private String zipFileName;
    private File directoryToZip;
    private FilenameFilter fileFilter;
    private File zipFile;
    private ZipFile zipFileObj = null;
    private String dirToStart;

    public Zipper(File dirToZip, File zipFile) {
        this.initialize(dirToZip, zipFile, null);
    }

    public Zipper(File dirToZip, File zipFile, FilenameFilter filter) {
        this.initialize(dirToZip, zipFile, filter);
    }

    private void addFile(File file) throws IOException {
        this.fileLength += file.length();
        ++this.fileCounter;
        String absolutePath = file.getAbsolutePath();
        int index = absolutePath.indexOf(this.dirToStart);
        String zipEntryName = absolutePath.substring(index, absolutePath.length());
        byte[] b = new byte[(int)file.length()];
        ZipEntry cpZipEntry = new ZipEntry(zipEntryName);
        this.zos.putNextEntry(cpZipEntry);
        this.zos.write(b, 0, (int)file.length());
        this.zos.closeEntry();
    }

    @Override
    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    @Override
    public File getDirectoryToZip() {
        return this.directoryToZip;
    }

    @Override
    public String getDirToStart() {
        return this.dirToStart;
    }

    @Override
    public int getFileCounter() {
        return this.fileCounter;
    }

    @Override
    public FilenameFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public long getFileLength() {
        return this.fileLength;
    }

    @Override
    public File getZipFile() {
        return this.zipFile;
    }

    @Override
    public String getZipFileComment() {
        return this.zipFileComment;
    }

    @Override
    public String getZipFileName() {
        return this.zipFileName;
    }

    @Override
    public ZipFile getZipFileObj() {
        return this.zipFileObj;
    }

    @Override
    public int getZipLevel() {
        return this.zipLevel;
    }

    private void initialize(File dirToZip, File zipFile, FilenameFilter filter) {
        this.directoryToZip = dirToZip;
        this.dirToStart = this.directoryToZip.getName();
        this.zipFile = zipFile;
        this.fileLength = 0L;
        this.fileCounter = 0;
        this.setFileFilter(filter);
    }

    @Override
    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    @Override
    public void setDirectoryToZip(File directoryToZip) {
        this.directoryToZip = directoryToZip;
    }

    @Override
    public void setDirToStart(String dirToStart) {
        this.dirToStart = dirToStart;
    }

    @Override
    public void setFileCounter(int fileCounter) {
        this.fileCounter = fileCounter;
    }

    @Override
    public void setFileFilter(FilenameFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    @Override
    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void setZipFileComment(String zipFileComment) {
        this.zipFileComment = zipFileComment;
    }

    @Override
    public void setZipFileName(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    @Override
    public void setZipFileObj(ZipFile zipFileObj) {
        this.zipFileObj = zipFileObj;
    }

    @Override
    public void setZipLevel(int zipLevel) {
        this.zipLevel = zipLevel;
    }

    public void zip() {
        block11: {
            FileOutputStream fos = null;
            try {
                try {
                    if (!this.directoryToZip.exists()) {
                        throw new IOException("Directory with the name " + this.directoryToZip.getName() + " does not exist.");
                    }
                    if (!this.zipFile.exists()) {
                        throw new FileDoesNotExistException("Zipfile with the name " + this.zipFile.getName() + " does not exist.");
                    }
                    fos = new FileOutputStream(this.zipFile);
                    this.zos = new ZipOutputStream(fos);
                    if (this.zipLevel > 0) {
                        this.zos.setLevel(this.zipLevel);
                    } else {
                        this.zos.setLevel(9);
                    }
                    if (this.zipFileComment != null) {
                        this.zos.setComment(this.zipFileComment);
                    }
                    if (this.compressionMethod > 0) {
                        this.zos.setMethod(this.compressionMethod);
                    }
                    this.zipFiles(this.directoryToZip);
                    this.zos.flush();
                    this.zos.finish();
                    this.zos.close();
                    fos.flush();
                    fos.close();
                    fos = null;
                    this.zos = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StreamUtils.closeOutputStream(fos);
                    StreamUtils.closeOutputStream((OutputStream)this.zos);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeOutputStream(fos);
                StreamUtils.closeOutputStream((OutputStream)this.zos);
                throw throwable;
            }
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeOutputStream((OutputStream)this.zos);
        }
    }

    private void zipFiles(File file) throws IOException {
        if (file.isDirectory()) {
            List<File> foundedFiles;
            if (this.fileFilter != null) {
                List<File> tmp;
                File[] tmpfList = file.listFiles(this.fileFilter);
                List<File> foundedDirs = FileSearchUtils.listDirs(file);
                if (foundedDirs.size() > 0) {
                    tmp = Arrays.asList(tmpfList);
                    foundedDirs.addAll(tmp);
                    foundedFiles = foundedDirs;
                } else {
                    tmp = Arrays.asList(tmpfList);
                    foundedFiles = tmp;
                }
            } else {
                List<File> tmp;
                File[] fList = file.listFiles();
                foundedFiles = tmp = Arrays.asList(fList);
            }
            int i = 0;
            while (i < foundedFiles.size()) {
                this.zipFiles(foundedFiles.get(i));
                ++i;
            }
        } else {
            this.addFile(file);
        }
    }
}

