/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sourceforge.jaulp.file.FileConst;
import net.sourceforge.jaulp.file.exceptions.FileDoesNotExistException;
import net.sourceforge.jaulp.file.search.FileSearchUtils;
import net.sourceforge.jaulp.io.StreamUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    private static void addFile(File file, File dirToZip, ZipOutputStream zos) throws IOException {
        String absolutePath = file.getAbsolutePath();
        int index = absolutePath.indexOf(dirToZip.getName());
        String zipEntryName = absolutePath.substring(index, absolutePath.length());
        byte[] b = new byte[(int)file.length()];
        ZipEntry cpZipEntry = new ZipEntry(zipEntryName);
        zos.putNextEntry(cpZipEntry);
        zos.write(b, 0, (int)file.length());
        zos.closeEntry();
    }

    public static void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        File fileToExtract = new File(toDirectory, target.getName());
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            int c;
            ZipEntry ze = zipFile.getEntry(target.getName());
            is = zipFile.getInputStream(ze);
            bis = new BufferedInputStream(is);
            new File(fileToExtract.getParent()).mkdirs();
            fos = new FileOutputStream(fileToExtract);
            bos = new BufferedOutputStream(fos);
            while ((c = bis.read()) != -1) {
                bos.write((byte)c);
            }
            bos.flush();
            bos.close();
        }
        catch (Throwable throwable) {
            StreamUtils.closeInputStream(bis);
            StreamUtils.closeInputStream(is);
            StreamUtils.closeOutputStream(fos);
            StreamUtils.closeOutputStream(bos);
            throw throwable;
        }
        StreamUtils.closeInputStream((InputStream)bis);
        StreamUtils.closeInputStream((InputStream)is);
        StreamUtils.closeOutputStream((OutputStream)fos);
        StreamUtils.closeOutputStream((OutputStream)bos);
    }

    public static boolean isZip(String filename) {
        int i = 0;
        while (i < FileConst.ZIP_EXTENSIONS.length) {
            if (filename.endsWith(FileConst.ZIP_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void unzip(ZipFile zipFile, File toDir) throws IOException {
        try {
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipUtils.extractZipEntry(zipFile, entry, toDir);
            }
            zipFile.close();
        }
        finally {
            zipFile.close();
        }
    }

    public static void zip(File fileToZip, File zipFile) throws Exception {
        ZipUtils.zip(fileToZip, zipFile, null);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter) {
        ZipUtils.zip(dirToZip, zipFile, filter, true);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter, boolean createFile) {
        block9: {
            ZipOutputStream zos = null;
            FileOutputStream fos = null;
            try {
                try {
                    if (!dirToZip.exists()) {
                        throw new IOException("Directory with the name " + dirToZip.getName() + " does not exist.");
                    }
                    if (!zipFile.exists()) {
                        if (createFile) {
                            zipFile.createNewFile();
                        } else {
                            throw new FileDoesNotExistException("Zipfile with the name " + zipFile.getName() + " does not exist.");
                        }
                    }
                    fos = new FileOutputStream(zipFile);
                    zos = new ZipOutputStream(fos);
                    zos.setLevel(9);
                    ZipUtils.zipFiles(dirToZip, dirToZip, zos, filter);
                    zos.flush();
                    zos.finish();
                    zos.close();
                    fos.flush();
                    fos.close();
                    fos = null;
                    zos = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StreamUtils.closeOutputStream(fos);
                    StreamUtils.closeOutputStream(zos);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeOutputStream(fos);
                StreamUtils.closeOutputStream(zos);
                throw throwable;
            }
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeOutputStream((OutputStream)zos);
        }
    }

    private static void zipFiles(File file, File dirToZip, ZipOutputStream zos, FilenameFilter fileFilter) throws IOException {
        if (file.isDirectory()) {
            List<File> foundedFiles;
            if (fileFilter != null) {
                List<File> tmp;
                File[] tmpfList = file.listFiles(fileFilter);
                List<File> foundedDirs = FileSearchUtils.listDirs(file);
                if (foundedDirs.size() > 0) {
                    tmp = Arrays.asList(tmpfList);
                    foundedDirs.addAll(tmp);
                    foundedFiles = foundedDirs;
                } else {
                    tmp = Arrays.asList(tmpfList);
                    foundedFiles = tmp;
                }
            } else {
                List<File> tmp;
                File[] fList = file.listFiles();
                foundedFiles = tmp = Arrays.asList(fList);
            }
            int i = 0;
            while (i < foundedFiles.size()) {
                ZipUtils.zipFiles(foundedFiles.get(i), dirToZip, zos, fileFilter);
                ++i;
            }
        } else {
            ZipUtils.addFile(file, dirToZip, zos);
        }
    }
}

