/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.zip;

import java.io.IOException;
import java.io.InputStream;

public class ZipDecryptInputStream
extends InputStream {
    private static final int[] CRC_TABLE = new int[256];
    private static final int DECRYPT_HEADER_SIZE = 12;
    private static final int[] LFH_SIGNATURE;
    private final InputStream delegate;
    private final String password;
    private final int[] keys = new int[3];
    private State state = State.SIGNATURE;
    private int skipBytes;
    private int compressedSize;
    private int value;
    private int valuePos;
    private int valueInc;
    private static /* synthetic */ int[] $SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State;

    static {
        int i = 0;
        while (i < 256) {
            int r = i;
            int j = 0;
            while (j < 8) {
                r = (r & 1) == 1 ? r >>> 1 ^ 0xEDB88320 : (r >>>= 1);
                ++j;
            }
            ZipDecryptInputStream.CRC_TABLE[i] = r;
            ++i;
        }
        LFH_SIGNATURE = new int[]{80, 75, 3, 4};
    }

    public ZipDecryptInputStream(InputStream stream, String password) {
        this.delegate = stream;
        this.password = password;
    }

    @Override
    public int read() throws IOException {
        int result;
        block23: {
            block22: {
                result = this.delegate.read();
                if (this.skipBytes != 0) break block22;
                switch (ZipDecryptInputStream.$SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State()[this.state.ordinal()]) {
                    case 1: {
                        if (result != LFH_SIGNATURE[this.valuePos]) {
                            this.state = State.TAIL;
                            break;
                        }
                        ++this.valuePos;
                        if (this.valuePos >= LFH_SIGNATURE.length) {
                            this.skipBytes = 2;
                            this.state = State.FLAGS;
                            break;
                        }
                        break block23;
                    }
                    case 2: {
                        if ((result & 1) == 0) {
                            throw new IllegalStateException("ZIP not password protected.");
                        }
                        if ((result & 0x40) == 64) {
                            throw new IllegalStateException("Strong encryption used.");
                        }
                        if ((result & 8) == 8) {
                            throw new IllegalStateException("Unsupported ZIP format.");
                        }
                        --result;
                        this.compressedSize = 0;
                        this.valuePos = 0;
                        this.valueInc = 12;
                        this.state = State.COMPRESSED_SIZE;
                        this.skipBytes = 11;
                        break;
                    }
                    case 3: {
                        this.compressedSize += result << 8 * this.valuePos;
                        if ((result -= this.valueInc) < 0) {
                            this.valueInc = 1;
                            result += 256;
                        } else {
                            this.valueInc = 0;
                        }
                        ++this.valuePos;
                        if (this.valuePos > 3) {
                            this.valuePos = 0;
                            this.value = 0;
                            this.state = State.FN_LENGTH;
                            this.skipBytes = 4;
                            break;
                        }
                        break block23;
                    }
                    case 4: 
                    case 5: {
                        this.value += result << 8 * this.valuePos;
                        if (this.valuePos == 1) {
                            this.valuePos = 0;
                            if (this.state == State.FN_LENGTH) {
                                this.state = State.EF_LENGTH;
                                break;
                            }
                            this.state = State.HEADER;
                            this.skipBytes = this.value;
                            break;
                        }
                        this.valuePos = 1;
                        break;
                    }
                    case 6: {
                        this.initKeys(this.password);
                        int i = 0;
                        while (i < 12) {
                            this.updateKeys((byte)(result ^ this.decryptByte()));
                            result = this.delegate.read();
                            ++i;
                        }
                        this.compressedSize -= 12;
                        this.state = State.DATA;
                    }
                    case 7: {
                        result = (result ^ this.decryptByte()) & 0xFF;
                        this.updateKeys((byte)result);
                        --this.compressedSize;
                        if (this.compressedSize != 0) break block23;
                        this.valuePos = 0;
                        this.state = State.SIGNATURE;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block23;
            }
            --this.skipBytes;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    private void initKeys(String password) {
        this.keys[0] = 305419896;
        this.keys[1] = 591751049;
        this.keys[2] = 878082192;
        int i = 0;
        while (i < password.length()) {
            this.updateKeys((byte)(password.charAt(i) & 0xFF));
            ++i;
        }
    }

    private void updateKeys(byte charAt) {
        this.keys[0] = this.crc32(this.keys[0], charAt);
        this.keys[1] = this.keys[1] + (this.keys[0] & 0xFF);
        this.keys[1] = this.keys[1] * 134775813 + 1;
        this.keys[2] = this.crc32(this.keys[2], (byte)(this.keys[1] >> 24));
    }

    private byte decryptByte() {
        int temp = this.keys[2] | 2;
        return (byte)(temp * (temp ^ 1) >>> 8);
    }

    private int crc32(int oldCrc, byte charAt) {
        return oldCrc >>> 8 ^ CRC_TABLE[(oldCrc ^ charAt) & 0xFF];
    }

    static /* synthetic */ int[] $SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State() {
        if ($SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State != null) {
            return $SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State;
        }
        int[] nArray = new int[State.values().length];
        try {
            nArray[State.COMPRESSED_SIZE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.DATA.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.EF_LENGTH.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.FLAGS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.FN_LENGTH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.HEADER.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.SIGNATURE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[State.TAIL.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$net$sourceforge$jaulp$file$zip$ZipDecryptInputStream$State = nArray;
        return nArray;
    }

    private static enum State {
        SIGNATURE,
        FLAGS,
        COMPRESSED_SIZE,
        FN_LENGTH,
        EF_LENGTH,
        HEADER,
        DATA,
        TAIL;

    }
}

