/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.write;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.jaulp.io.StreamUtils;

public final class WriteFileUtils {
    private static final Logger LOGGER = Logger.getLogger(WriteFileUtils.class.getName());

    private WriteFileUtils() {
    }

    public static void readSourceFileAndWriteDestFile(String srcfile, String destFile) {
        block6: {
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(srcfile);
                fos = new FileOutputStream(destFile);
                bis = new BufferedInputStream(fis);
                bos = new BufferedOutputStream(fos);
                int availableLength = bis.available();
                byte[] totalBytes = new byte[availableLength];
                bis.read(totalBytes, 0, availableLength);
                bos.write(totalBytes, 0, availableLength);
                bos.flush();
                bis.close();
                bos.close();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "readSourceFileAndWriteDestFile failed...\n" + e.getMessage(), e);
                StreamUtils.closeInputStream((InputStream)bis);
                StreamUtils.closeOutputStream(bos);
                StreamUtils.closeInputStream((InputStream)fis);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "readSourceFileAndWriteDestFile failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeInputStream(bis);
                    StreamUtils.closeOutputStream(bos);
                    StreamUtils.closeInputStream((InputStream)fis);
                    StreamUtils.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
                StreamUtils.closeInputStream((InputStream)bis);
                StreamUtils.closeOutputStream((OutputStream)bos);
                StreamUtils.closeInputStream((InputStream)fis);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            StreamUtils.closeInputStream((InputStream)bis);
            StreamUtils.closeOutputStream((OutputStream)bos);
            StreamUtils.closeInputStream((InputStream)fis);
            StreamUtils.closeOutputStream((OutputStream)fos);
        }
    }

    public static void storeByteArrayToFile(byte[] data, File file) {
        block6: {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(data);
                bos.flush();
                bos.close();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "storeByteArrayToFile failed...\n" + e.getMessage(), e);
                StreamUtils.closeOutputStream((OutputStream)bos);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "storeByteArrayToFile failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeOutputStream(bos);
                    StreamUtils.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
                StreamUtils.closeOutputStream((OutputStream)bos);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            StreamUtils.closeOutputStream((OutputStream)bos);
            StreamUtils.closeOutputStream((OutputStream)fos);
        }
    }

    public static boolean string2File(File file, String string2write) {
        return WriteFileUtils.writeStringToFile(file, string2write, null);
    }

    public static boolean string2File(File file, String string2write, String encoding) {
        return WriteFileUtils.writeStringToFile(file, string2write, encoding);
    }

    public static void string2File(String string2write, String nameOfFile) {
        block5: {
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(nameOfFile));
                    bufferedWriter.write(string2write);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "string2File failed...\n" + e.getMessage(), e);
                    StreamUtils.closeWriter((Writer)bufferedWriter);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeWriter(bufferedWriter);
                throw throwable;
            }
            StreamUtils.closeWriter((Writer)bufferedWriter);
        }
    }

    public static void write2File(Reader reader, Writer writer, boolean closeStream) {
        try {
            try {
                int byt;
                while ((byt = reader.read()) != -1) {
                    writer.write(byt);
                }
                if (closeStream) {
                    reader.close();
                    writer.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "write2File failed...\n" + e.getMessage(), e);
                if (closeStream) {
                    StreamUtils.closeReader((Reader)reader);
                    StreamUtils.closeWriter((Writer)writer);
                }
            }
        }
        finally {
            if (closeStream) {
                StreamUtils.closeReader((Reader)reader);
                StreamUtils.closeWriter((Writer)writer);
            }
        }
    }

    public static void write2File(String inputFile, String outputFile) {
        block6: {
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(inputFile);
                fos = new FileOutputStream(outputFile);
                bis = new BufferedInputStream(fis);
                bos = new BufferedOutputStream(fos);
                StreamUtils.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos, (boolean)true);
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "write2File failed...\n" + e.getMessage(), e);
                StreamUtils.closeInputStream((InputStream)fis);
                StreamUtils.closeOutputStream((OutputStream)fos);
                StreamUtils.closeInputStream((InputStream)bis);
                StreamUtils.closeOutputStream((OutputStream)bos);
                break block6;
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "write2File failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeInputStream(fis);
                    StreamUtils.closeOutputStream(fos);
                    StreamUtils.closeInputStream(bis);
                    StreamUtils.closeOutputStream(bos);
                    throw throwable;
                }
                StreamUtils.closeInputStream((InputStream)fis);
                StreamUtils.closeOutputStream((OutputStream)fos);
                StreamUtils.closeInputStream((InputStream)bis);
                StreamUtils.closeOutputStream((OutputStream)bos);
                break block6;
            }
            StreamUtils.closeInputStream((InputStream)fis);
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeInputStream((InputStream)bis);
            StreamUtils.closeOutputStream((OutputStream)bos);
        }
    }

    public static void write2File(String inputFile, Writer writer, boolean closeWriter) {
        block8: {
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(inputFile));
                    WriteFileUtils.write2File(bufferedReader, writer, closeWriter);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, "write2File failed...\n" + e.getMessage(), e);
                    if (closeWriter) {
                        StreamUtils.closeReader((Reader)bufferedReader);
                        StreamUtils.closeWriter((Writer)writer);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (closeWriter) {
                    StreamUtils.closeReader(bufferedReader);
                    StreamUtils.closeWriter((Writer)writer);
                }
                throw throwable;
            }
            if (closeWriter) {
                StreamUtils.closeReader((Reader)bufferedReader);
                StreamUtils.closeWriter((Writer)writer);
            }
        }
    }

    public static void write2FileWithBuffer(String inputFile, String outputFile) {
        block7: {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = StreamUtils.getInputStream((File)new File(inputFile));
                outputStream = StreamUtils.getOutputStream((File)new File(outputFile));
                int counter = 0;
                byte[] byteArray = new byte[8192];
                while ((counter = inputStream.read(byteArray)) != -1) {
                    outputStream.write(byteArray, 0, counter);
                }
                inputStream.close();
                outputStream.close();
                inputStream = null;
                outputStream = null;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "write2FileWithBuffer failed...\n" + e.getMessage(), e);
                StreamUtils.closeInputStream((InputStream)inputStream);
                StreamUtils.closeOutputStream((OutputStream)outputStream);
                break block7;
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "write2FileWithBuffer failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeInputStream(inputStream);
                    StreamUtils.closeOutputStream(outputStream);
                    throw throwable;
                }
                StreamUtils.closeInputStream((InputStream)inputStream);
                StreamUtils.closeOutputStream((OutputStream)outputStream);
                break block7;
            }
            StreamUtils.closeInputStream((InputStream)inputStream);
            StreamUtils.closeOutputStream((OutputStream)outputStream);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byteArray) throws IOException {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(byteArray);
                fos.close();
                bos.close();
                fos = null;
                bos = null;
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeOutputStream(fos);
            StreamUtils.closeOutputStream(bos);
            throw throwable;
        }
        StreamUtils.closeOutputStream((OutputStream)fos);
        StreamUtils.closeOutputStream((OutputStream)bos);
    }

    public static void writeByteArrayToFile(String filename, byte[] byteArray) throws IOException {
        File file = new File(filename);
        WriteFileUtils.writeByteArrayToFile(file, byteArray);
    }

    public static void writeLinesToFile(Collection<String> collection, File output) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileUtils.string2File(output, sb.toString());
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileUtils.string2File(output, sb.toString(), encoding);
    }

    /*
     * Loose catch block
     */
    public static void writeLinesToFile(File output, List<String> input, String encoding) {
        block9: {
            PrintWriter out = null;
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            String lineSeparator = System.getProperty("line.separator");
            try {
                fos = new FileOutputStream(output);
                osw = encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, encoding);
                out = new PrintWriter(osw);
                int size = input.size();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < size) {
                    String entry = input.get(i);
                    sb.append(String.valueOf(entry) + lineSeparator);
                    ++i;
                }
                out.write(sb.toString());
                out.close();
                osw.close();
                fos.close();
                out = null;
                osw = null;
                fos = null;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.SEVERE, "writeLinesToFile failed...\n" + e.getMessage(), e);
                StreamUtils.closeOutputStream((OutputStream)fos);
                StreamUtils.closeWriter((Writer)osw);
                StreamUtils.closeWriter((Writer)out);
                break block9;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "writeLinesToFile failed...\n" + e.getMessage(), e);
                StreamUtils.closeOutputStream((OutputStream)fos);
                StreamUtils.closeWriter((Writer)osw);
                StreamUtils.closeWriter((Writer)out);
                break block9;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "writeLinesToFile failed...\n" + e.getMessage(), e);
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeOutputStream(fos);
                        StreamUtils.closeWriter(osw);
                        StreamUtils.closeWriter(out);
                        throw throwable;
                    }
                }
                StreamUtils.closeOutputStream((OutputStream)fos);
                StreamUtils.closeWriter((Writer)osw);
                StreamUtils.closeWriter((Writer)out);
                break block9;
            }
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeWriter((Writer)osw);
            StreamUtils.closeWriter((Writer)out);
        }
    }

    public static void writeProperties2File(String filename, Properties properties) {
        block5: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(filename);
                    properties.store(fos, null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "writeProperties2File failed...\n" + e.getMessage(), e);
                    StreamUtils.closeOutputStream((OutputStream)fos);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeOutputStream(fos);
                throw throwable;
            }
            StreamUtils.closeOutputStream((OutputStream)fos);
        }
    }

    public static boolean writeStringToFile(File file, String string2write, String encoding) {
        boolean iswritten;
        block6: {
            iswritten = true;
            PrintWriter printWriter = null;
            BufferedOutputStream bos = null;
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                osw = encoding == null ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
                printWriter = new PrintWriter(osw);
                printWriter.write(string2write);
                printWriter.close();
                osw.close();
                bos.close();
                fos.close();
                printWriter = null;
                osw = null;
                bos = null;
                fos = null;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "writeStringToFile failed...\n" + e.getMessage(), e);
                iswritten = false;
                StreamUtils.closeWriter(printWriter);
                StreamUtils.closeWriter((Writer)osw);
                StreamUtils.closeOutputStream((OutputStream)bos);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            catch (IOException e) {
                try {
                    LOGGER.log(Level.SEVERE, "writeStringToFile failed...\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeWriter(printWriter);
                    StreamUtils.closeWriter(osw);
                    StreamUtils.closeOutputStream(bos);
                    StreamUtils.closeOutputStream((OutputStream)fos);
                    throw throwable;
                }
                StreamUtils.closeWriter(printWriter);
                StreamUtils.closeWriter((Writer)osw);
                StreamUtils.closeOutputStream((OutputStream)bos);
                StreamUtils.closeOutputStream((OutputStream)fos);
                break block6;
            }
            StreamUtils.closeWriter((Writer)printWriter);
            StreamUtils.closeWriter((Writer)osw);
            StreamUtils.closeOutputStream((OutputStream)bos);
            StreamUtils.closeOutputStream((OutputStream)fos);
        }
        return iswritten;
    }
}

