/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.url;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import net.sourceforge.jaulp.file.url.Protocol;

public class URLUtils {
    public boolean isJar(URL url) {
        return url.getProtocol().equals(Protocol.JAR.getProtocol());
    }

    public boolean isEar(URL url) {
        return url.getProtocol().equals(Protocol.EAR.getProtocol());
    }

    public String getFilename(URL url) throws UnsupportedEncodingException {
        if (this.isJar(url) || this.isEar(url)) {
            String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
            fileName = fileName.substring(5, fileName.indexOf("!"));
            return fileName;
        }
        return URLDecoder.decode(url.getFile(), "UTF-8");
    }
}

