/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.search;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import net.sourceforge.jaulp.file.filter.MultiplyExtensionsFileFilter;
import net.sourceforge.jaulp.regex.REUtils;

public final class FileSearchUtils {
    private FileSearchUtils() {
    }

    public static List<File> findFilesWithFilter(File dir, String ... extension) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        File[] children = dir.listFiles((FileFilter)new MultiplyExtensionsFileFilter(true, extension));
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                foundedFileList.addAll(FileSearchUtils.findFilesWithFilter(children[i], extension));
            } else {
                foundedFileList.add(children[i].getAbsoluteFile());
            }
            ++i;
        }
        return foundedFileList;
    }

    public static List<File> findAllFiles(File dir, String fileSearchPattern) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundFiles;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                List<File> foundedFiles = FileSearchUtils.findAllFiles(children[i], fileSearchPattern);
                foundFiles.addAll(foundedFiles);
            } else {
                String filename = children[i].getName();
                if (filename.matches(fileSearchPattern)) {
                    foundFiles.add(children[i].getAbsoluteFile());
                }
            }
            ++i;
        }
        return foundFiles;
    }

    public static String getSearchFilePattern(String ... fileExtensions) {
        if (fileExtensions.length == 0) {
            return "";
        }
        String searchFilePatternPrefix = "([^\\s]+(\\.(?i)(";
        String searchFilePatternSuffix = "))$)";
        StringBuilder sb = new StringBuilder();
        int count = 1;
        String[] stringArray = fileExtensions;
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension = stringArray[n2];
            if (count < fileExtensions.length) {
                sb.append(String.valueOf(fileExtension) + "|");
            } else {
                sb.append(fileExtension);
            }
            ++count;
            ++n2;
        }
        return String.valueOf(searchFilePatternPrefix) + sb.toString().trim() + searchFilePatternSuffix;
    }

    public static boolean containsFile(File parent, File search) {
        boolean exists = false;
        String[] children = parent.list();
        if (children == null) {
            return false;
        }
        List<String> fileList = Arrays.asList(children);
        if (fileList.contains(search.getName())) {
            exists = true;
        }
        return exists;
    }

    public static boolean containsFile(File fileToSearch, String pathname) {
        String[] allFiles = fileToSearch.list();
        if (allFiles == null) {
            return false;
        }
        List<String> list = Arrays.asList(allFiles);
        return list.contains(pathname);
    }

    public static boolean containsFileRecursive(File parent, File search) {
        File toSearch = search.getAbsoluteFile();
        boolean exists = false;
        File[] children = parent.getAbsoluteFile().listFiles();
        if (children == null) {
            return false;
        }
        List<File> fileList = Arrays.asList(children);
        for (File currentFile : fileList) {
            if (currentFile.isDirectory() && (exists = FileSearchUtils.containsFileRecursive(currentFile, toSearch))) {
                return true;
            }
            if (!fileList.contains(toSearch)) continue;
            return true;
        }
        return exists;
    }

    public static List<File> findFiles(File dir, String filenameToSearch) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = REUtils.replaceWildcardsWithRE((String)filenameToSearch);
        String[] children = dir.list();
        int i = 0;
        while (i < children.length) {
            String filename = children[i];
            if (filename.matches(regex)) {
                File foundedFile = new File(filename);
                foundedFileList.add(foundedFile);
            }
            ++i;
        }
        return foundedFileList;
    }

    public static Vector<File> findFiles(String start, String[] extensions) {
        Vector<File> files = new Vector<File>();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(start);
        if (startdir.isDirectory()) {
            dirs.push(new File(start));
        }
        while (dirs.size() > 0) {
            File dirFiles = (File)dirs.pop();
            String[] s = dirFiles.list();
            if (s == null) continue;
            int i = 0;
            while (i < s.length) {
                File file = new File(String.valueOf(dirFiles.getAbsolutePath()) + File.separator + s[i]);
                if (file.isDirectory()) {
                    dirs.push(file);
                } else if (FileSearchUtils.match(s[i], extensions)) {
                    files.addElement(file);
                }
                ++i;
            }
        }
        return files;
    }

    public static List<File> findFilesRecursive(File dir, String filenameToSearch) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = REUtils.replaceWildcardsWithRE((String)filenameToSearch);
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                List<File> foundedFiles = FileSearchUtils.findFilesRecursive(children[i], filenameToSearch);
                foundedFileList.addAll(foundedFiles);
            } else {
                String filename = children[i].getName();
                if (filename.matches(regex)) {
                    foundedFileList.add(children[i].getAbsoluteFile());
                }
            }
            ++i;
        }
        return foundedFileList;
    }

    public static long countAllFilesInDirectory(File dir, long length, boolean includeDirectories) {
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return length;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                if (includeDirectories) {
                    ++length;
                }
                length = FileSearchUtils.countAllFilesInDirectory(children[i], length, includeDirectories);
            } else {
                ++length;
            }
            ++i;
        }
        return length;
    }

    public static long getFileLengthInKilobytes(File dir) {
        long fileLength = dir.getTotalSpace();
        return fileLength / 1024L;
    }

    public static long getFileLengthInMegabytes(File dir) {
        return FileSearchUtils.getFileLengthInKilobytes(dir) / 1024L;
    }

    public static List<File> getAllFilesFromDirRecursive(File dir) {
        return FileSearchUtils.findFilesRecursive(dir, "*");
    }

    public static List<File> getAllFilesFromDir(File dir) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        int i = 0;
        while (i < children.length) {
            if (!children[i].isDirectory()) {
                foundedFileList.add(children[i].getAbsoluteFile());
            }
            ++i;
        }
        return foundedFileList;
    }

    public static List<File> listDirs(File dir) {
        ArrayList<File> foundedDirs = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int i = 0;
        while (i < fileArray.length) {
            if (fileArray[i].isDirectory()) {
                foundedDirs.add(fileArray[i]);
            }
            ++i;
        }
        return foundedDirs;
    }

    public static boolean match(String stringToMatch, String[] suffixes) {
        int i = 0;
        while (i < suffixes.length) {
            String suffix = suffixes[i];
            int suffixesLength = suffixes[i].length();
            int stringToMatchLength = stringToMatch.length();
            int result = stringToMatchLength - suffixesLength;
            String extensionToMatch = stringToMatch.substring(result, stringToMatchLength);
            boolean equals = extensionToMatch.equalsIgnoreCase(suffix);
            if (stringToMatchLength >= suffixesLength && equals) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

