/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.rename;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.jaulp.file.FileUtils;
import net.sourceforge.jaulp.file.copy.CopyFileUtils;
import net.sourceforge.jaulp.file.delete.DeleteFileUtils;
import net.sourceforge.jaulp.file.exceptions.FileDoesNotExistException;
import net.sourceforge.jaulp.file.exceptions.FileIsADirectoryException;
import net.sourceforge.jaulp.file.exceptions.FileNotRenamedException;
import net.sourceforge.jaulp.file.search.FileSearchUtils;

public final class RenameFileUtils {
    private static final Logger LOGGER = Logger.getLogger(RenameFileUtils.class.getName());

    private RenameFileUtils() {
    }

    public static String appendSystemtimeToFilename(File fileToRename) {
        return RenameFileUtils.appendSystemtimeToFilename(fileToRename, null);
    }

    public static String appendSystemtimeToFilename(File fileToRename, Date add2Name) {
        SimpleDateFormat df;
        String format = "HHmmssSSS";
        String sysTime = null;
        if (add2Name != null) {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(add2Name);
        } else {
            df = new SimpleDateFormat("HHmmssSSS");
            sysTime = df.format(new Date());
        }
        String fileName = fileToRename.getName();
        int ext_index = fileName.lastIndexOf(".");
        String ext = fileName.substring(ext_index, fileName.length());
        String newName = fileName.substring(0, ext_index);
        newName = String.valueOf(newName) + "_" + sysTime + ext;
        return newName;
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix) throws IOException, FileDoesNotExistException {
        return RenameFileUtils.changeAllFilenameSuffix(file, oldSuffix, newSuffix, false);
    }

    public static List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException {
        ArrayList<File> notDeletedFiles = null;
        String filePath = file.getAbsolutePath();
        String[] suffix = new String[]{oldSuffix};
        Vector<File> files = FileSearchUtils.findFiles(filePath, suffix);
        int fileCount = files.size();
        int i = 0;
        while (i < fileCount) {
            boolean success;
            File currentFile = files.elementAt(i);
            try {
                success = RenameFileUtils.changeFilenameSuffix(currentFile, newSuffix, delete);
            }
            catch (FileDoesNotExistException e) {
                LOGGER.log(Level.SEVERE, "changeAllFilenameSuffix failed...\n" + e.getMessage(), e);
                success = false;
            }
            if (!success) {
                if (notDeletedFiles != null) {
                    notDeletedFiles.add(currentFile);
                } else {
                    notDeletedFiles = new ArrayList<File>();
                    notDeletedFiles.add(currentFile);
                }
            }
            ++i;
        }
        return notDeletedFiles;
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix) throws FileNotRenamedException, FileDoesNotExistException, IOException {
        return RenameFileUtils.changeFilenameSuffix(file, newSuffix, false);
    }

    public static boolean changeFilenameSuffix(File file, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException {
        if (!file.exists()) {
            String error = "The " + file + " does not exists.";
            throw new FileDoesNotExistException(error);
        }
        String fileNamePrefix = FileUtils.getFilenamePrefix(file);
        String newFilename = String.valueOf(fileNamePrefix) + newSuffix;
        File file2 = new File(newFilename);
        boolean success = RenameFileUtils.renameFile(file, file2, delete);
        return success;
    }

    public static String getAbsolutPathWithoutFilename(File file) {
        String absolutePath = file.getAbsolutePath();
        int lastSlash_index = absolutePath.lastIndexOf("/");
        if (lastSlash_index < 0) {
            lastSlash_index = absolutePath.lastIndexOf("\\");
        }
        return absolutePath.substring(0, lastSlash_index + 1);
    }

    public static boolean moveFile(File srcFile, File destDir) {
        return RenameFileUtils.renameFile(srcFile, destDir, true);
    }

    public static boolean forceToMoveFile(File srcFile, File destDir) {
        boolean moved = false;
        try {
            moved = RenameFileUtils.renameFile(srcFile, destDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return moved;
    }

    public static boolean renameFile(File fileToRename, File newFileName) {
        return RenameFileUtils.renameFile(fileToRename, newFileName, false);
    }

    public static boolean renameFile(File fileToRename, File newFileName, boolean delete) {
        boolean success = fileToRename.renameTo(newFileName);
        if (!success) {
            System.err.println("The file " + fileToRename.getName() + " was not renamed.");
            if (delete) {
                System.err.println("Try to copy the content into the new file with the new name.");
                try {
                    boolean copied = CopyFileUtils.copyFile(fileToRename, newFileName);
                    if (copied) {
                        System.err.println("Sucessfully copied the old file " + fileToRename.getName() + " to the new file " + newFileName.getName() + ".");
                    } else {
                        System.err.println("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                    }
                }
                catch (IOException e) {
                    System.err.println("Try to copy file " + fileToRename.getName() + " into the new file " + newFileName.getName() + " failed.");
                }
                catch (FileIsADirectoryException e) {
                    e.printStackTrace();
                }
                System.err.println("Try to delete the old file " + fileToRename.getName() + ".");
                try {
                    DeleteFileUtils.delete(fileToRename);
                    success = true;
                }
                catch (IOException e) {
                    System.err.println("Try to delete the old file " + fileToRename.getName() + " failed.");
                }
            }
        }
        return success;
    }

    public static boolean renameFile(File fileToRename, String newFileNameWithoutAbsolutPath) {
        if (!fileToRename.exists()) {
            try {
                throw new FileDoesNotExistException("File" + fileToRename.getName() + " does not exists!");
            }
            catch (FileDoesNotExistException e) {
                e.printStackTrace();
                return false;
            }
        }
        String fileNameAbsolutPathPrefix = RenameFileUtils.getAbsolutPathWithoutFilename(fileToRename);
        StringBuffer sb = new StringBuffer();
        sb.append(fileNameAbsolutPathPrefix);
        sb.append(newFileNameWithoutAbsolutPath);
        File newNameForFile = new File(sb.toString());
        boolean sucess = RenameFileUtils.renameFile(fileToRename, newNameForFile);
        return sucess;
    }

    public static File renameFileWithSystemtime(File fileToRename) {
        String newFilenameWithSystemtime = RenameFileUtils.appendSystemtimeToFilename(fileToRename);
        File fileWithNewName = new File(fileToRename.getParent(), newFilenameWithSystemtime);
        RenameFileUtils.renameFile(fileToRename, fileWithNewName, true);
        return fileWithNewName;
    }
}

