/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.properties;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jaulp.file.copy.CopyFileUtils;
import net.sourceforge.jaulp.file.read.ReadFileUtils;
import net.sourceforge.jaulp.file.search.FileSearchUtils;
import net.sourceforge.jaulp.lang.PropertiesUtils;

public class PropertiesFileUtils {
    public static List<String> removeComments(File propertiesFile) throws IOException {
        if (propertiesFile != null && !propertiesFile.getName().matches(FileSearchUtils.getSearchFilePattern("properties"))) {
            throw new IllegalArgumentException("The given file is not an properties file.");
        }
        List<String> lines = ReadFileUtils.readLinesInList(propertiesFile);
        Iterator<String> itr = lines.iterator();
        while (itr.hasNext()) {
            String line = itr.next();
            if (!line.startsWith("#") && line.trim().length() != 0) continue;
            itr.remove();
        }
        return lines;
    }

    public static File newBackupOf(File file) throws IOException {
        return CopyFileUtils.newBackupOf(file, Charset.forName("ISO-8859-1"), Charset.forName("UTF-8"));
    }

    public static Map<File, Map<String, List<String>>> getRedundantKeys(File dirToSearch) throws IOException {
        List<File> foundFiles = FileSearchUtils.findAllFiles(dirToSearch, FileSearchUtils.getSearchFilePattern("properties"));
        LinkedHashMap linesMap = new LinkedHashMap();
        LinkedHashMap<File, Map<String, List<String>>> fileMap = new LinkedHashMap<File, Map<String, List<String>>>();
        for (File file : foundFiles) {
            List<String> lines = PropertiesFileUtils.removeComments(file);
            Properties p = PropertiesUtils.loadProperties((File)file);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                for (String line : lines) {
                    char nextChar;
                    if (!line.startsWith(key) || (nextChar = line.charAt(key.length())) == '.') continue;
                    if (nextChar == '=' || nextChar == ':' || nextChar == ' ') {
                        List<String> dl;
                        if (!linesMap.containsKey(key)) {
                            dl = new ArrayList<String>();
                            dl.add(line);
                            linesMap.put(key, dl);
                            continue;
                        }
                        dl = (List)linesMap.get(key);
                        dl.add(line);
                        linesMap.put(key, dl);
                        continue;
                    }
                    throw new RuntimeException("nextChar is '" + nextChar + "'");
                }
            }
            LinkedHashMap<String, List> duplicateKeys = new LinkedHashMap<String, List>();
            for (Map.Entry entry : linesMap.entrySet()) {
                if (1 >= ((List)entry.getValue()).size()) continue;
                duplicateKeys.put((String)entry.getKey(), (List)entry.getValue());
            }
            if (duplicateKeys.size() <= 0) continue;
            fileMap.put(file, duplicateKeys);
        }
        return fileMap;
    }
}

