/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.delete;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jaulp.file.exceptions.DirectoryHasNoContentException;
import net.sourceforge.jaulp.file.exceptions.FileDoesNotExistException;
import net.sourceforge.jaulp.file.exceptions.FileIsNotADirectoryException;
import net.sourceforge.jaulp.file.exceptions.FileIsSecurityRestrictedException;
import net.sourceforge.jaulp.file.search.FileSearchUtils;

public final class DeleteFileUtils {
    private DeleteFileUtils() {
    }

    public static Exception checkFile(File file) {
        Exception ex = null;
        String error = null;
        if (!file.exists()) {
            error = "The " + file + " does not exists.";
            ex = new FileDoesNotExistException(error);
            return ex;
        }
        if (!file.isDirectory()) {
            error = "The " + file + " is not a directory.";
            ex = new FileIsNotADirectoryException(error);
            return ex;
        }
        File[] ff = file.listFiles();
        if (ff == null) {
            error = "The " + file + " could not list the content.";
            ex = new DirectoryHasNoContentException(error);
        }
        return ex;
    }

    public static void deleteFiles(File file) throws IOException {
        File[] ff = file.listFiles();
        if (ff != null) {
            int i = 0;
            while (i < ff.length) {
                File f = ff[i];
                DeleteFileUtils.delete(f);
                ++i;
            }
        }
    }

    public static void deleteFilesWithFileFilter(File source, FileFilter includeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileUtils.deleteFilesWithFileFilter(source, includeFileFilter, null);
    }

    public static void deleteFilesWithFileFilter(File source, FileFilter includeFileFilter, FileFilter excludeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = includeFileFilter != null ? source.listFiles(includeFileFilter) : source.listFiles();
        if (includeFilesArray != null) {
            File[] excludeFilesArray = null;
            List<File> excludeFilesList = null;
            if (excludeFileFilter != null) {
                excludeFilesArray = source.listFiles(excludeFileFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (excludeFilesList != null && !excludeFilesList.isEmpty()) {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (!excludeFilesList.contains(currentFile)) {
                        if (currentFile.isDirectory()) {
                            DeleteFileUtils.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                        } else {
                            DeleteFileUtils.deleteFile(currentFile);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (currentFile.isDirectory()) {
                        DeleteFileUtils.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                    } else {
                        DeleteFileUtils.deleteFile(currentFile);
                    }
                    ++i;
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileUtils.deleteFilesWithFilenameFilter(source, includeFilenameFilter, null);
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = includeFilenameFilter != null ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (includeFilesArray != null) {
            File[] excludeFilesArray = null;
            List<File> excludeFilesList = null;
            if (excludeFilenameFilter != null) {
                excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (excludeFilesList != null && !excludeFilesList.isEmpty()) {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (!excludeFilesList.contains(currentFile)) {
                        if (currentFile.isDirectory()) {
                            DeleteFileUtils.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                        } else {
                            DeleteFileUtils.deleteFile(currentFile);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (currentFile.isDirectory()) {
                        DeleteFileUtils.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                    } else {
                        DeleteFileUtils.deleteFile(currentFile);
                    }
                    ++i;
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            DeleteFileUtils.deleteAllFiles(file);
        } else {
            String error = null;
            if (!file.delete()) {
                error = "Cannot delete the File " + file.getAbsolutePath() + ".";
                throw new IOException(error);
            }
        }
    }

    public static void delete(Collection<File> files) throws IOException {
        for (File file : files) {
            DeleteFileUtils.delete(file);
        }
    }

    public static void deleteAllFiles(File file) throws IOException {
        String error = null;
        if (!file.exists()) {
            return;
        }
        Exception ex = DeleteFileUtils.checkFile(file);
        if (ex != null) {
            try {
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DeleteFileUtils.deleteFiles(file);
        if (!file.delete()) {
            error = "Cannot delete the File " + file.getAbsolutePath() + ".";
            throw new IOException(error);
        }
    }

    public static void deleteAllFilesWithSuffix(File file, String theSuffix) throws IOException {
        String filePath = file.getAbsolutePath();
        String[] suffix = new String[]{theSuffix};
        Vector<File> files = FileSearchUtils.findFiles(filePath, suffix);
        int fileCount = files.size();
        int i = 0;
        while (i < fileCount) {
            DeleteFileUtils.deleteFile(files.elementAt(i));
            ++i;
        }
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        DeleteFileUtils.delete(fileToDelete);
    }
}

