/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.jaulp.file.write.WriteFileUtils;
import net.sourceforge.jaulp.io.StreamUtils;
import net.sourceforge.jaulp.string.StringUtils;

public final class CsvFileUtils {
    private CsvFileUtils() {
    }

    /*
     * Loose catch block
     */
    public static List<String> formatKommaSeperatedFileToList(File input, String encoding) {
        ArrayList<String> output;
        block10: {
            output = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                reader = (BufferedReader)StreamUtils.getReader((File)input, (String)encoding, (boolean)false);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] splittedData = line.split(",");
                    int i = 0;
                    while (i < splittedData.length) {
                        output.add(splittedData[i].trim());
                        ++i;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                StreamUtils.closeReader((Reader)reader);
                break block10;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                StreamUtils.closeReader((Reader)reader);
                break block10;
            }
            catch (IOException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeReader(reader);
                        throw throwable;
                    }
                }
                StreamUtils.closeReader((Reader)reader);
                break block10;
            }
            StreamUtils.closeReader((Reader)reader);
        }
        return output;
    }

    private static String formatListToString(List<String> list) {
        int lineLength = 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            String str = list.get(i);
            int length = str.length();
            lineLength = length + lineLength;
            sb.append(str);
            sb.append(", ");
            if (100 < lineLength) {
                sb.append("\n");
                lineLength = 0;
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public static void formatToCSV(File input, File output, String encoding) throws IOException {
        List<String> list = CsvFileUtils.readLinesInList(input, "UTF-8");
        String sb = CsvFileUtils.formatListToString(list);
        WriteFileUtils.writeStringToFile(output, sb, encoding);
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String[] splittedData;
            reader = (BufferedReader)StreamUtils.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null && position < (splittedData = line.split(",")).length - 1) {
                String s = StringUtils.removeQuotesFromString((String)splittedData[position]);
                output.add(s);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        if (putFirstLine) {
            output.remove(0);
        }
        return output;
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String splitChar, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamUtils.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedData = line.split(splitChar);
                if (position > splittedData.length - 1) continue;
                String s = StringUtils.removeQuotesFromString((String)splittedData[position]);
                output.add(s);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        if (putFirstLine) {
            output.remove(0);
        }
        return output;
    }

    public static Properties readFilelistToProperties(File input) throws IOException {
        List<String> list = CsvFileUtils.readLinesInList(input, null);
        Properties prop = new Properties();
        int i = 0;
        while (i < list.size()) {
            String element = list.get(i);
            prop.put(String.valueOf(i), element);
            ++i;
        }
        return prop;
    }

    public static List<String> readFileToList(File file) throws IOException {
        return CsvFileUtils.readFileToList(file, null);
    }

    public static List<String> readFileToList(File file, String encoding) throws IOException {
        ArrayList<String> fn = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamUtils.getReader((File)file, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                fn.add(line);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        return fn;
    }

    public static List<String[]> readFileToList(File file, String seperator, String encoding) throws IOException {
        ArrayList<String[]> fn = new ArrayList<String[]>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamUtils.getReader((File)file, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedLine = CsvFileUtils.getDataFromLine(line, seperator);
                fn.add(splittedLine);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        return fn;
    }

    public static int getLineCountFromCsvFile(File file) throws IOException {
        return CsvFileUtils.readFileToList(file).size();
    }

    public static String[] getDataFromLine(String line, String seperator) {
        return CsvFileUtils.getDataFromLine(line, seperator, false);
    }

    public static String[] getDataFromLine(String line, String seperator, boolean trim) {
        StringTokenizer tokenizer = new StringTokenizer(line, seperator);
        ArrayList<String> data = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String string = tokenizer.nextToken();
            if (trim) {
                data.add(string.trim());
                continue;
            }
            data.add(string);
        }
        String[] splittedLine = data.toArray(new String[0]);
        return splittedLine;
    }

    public static List<String> readLinesInList(File input, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamUtils.getReader((File)input, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        return output;
    }

    public static String[] sortData(File csvData, String encoding) throws FileNotFoundException, IOException {
        ArrayList<String> fn = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)StreamUtils.getReader((File)csvData, (String)encoding, (boolean)false);
            String line = null;
            while ((line = reader.readLine()) != null) {
                int last = 0;
                int index = line.indexOf(44);
                while (index != -1) {
                    String firstname = line.substring(last, index).trim();
                    fn.add(firstname);
                    last = index + 1;
                    index = line.indexOf(44, last);
                }
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeReader(reader);
            throw throwable;
        }
        StreamUtils.closeReader((Reader)reader);
        Object[] data = fn.toArray(new String[fn.size()]);
        Arrays.sort(data);
        return data;
    }

    public static void storeFilelistToProperties(File output, File input, String comments) throws IOException {
        Properties prop = CsvFileUtils.readFilelistToProperties(input);
        OutputStream out = StreamUtils.getOutputStream((File)output, (boolean)true);
        prop.store(out, comments);
        StreamUtils.closeOutputStream((OutputStream)out);
    }

    public static void writeLines(File output, Set<String> values, String encoding) throws IOException {
        CsvFileUtils.writeLinesToFile(values, output, encoding);
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) {
        StringBuffer sb = new StringBuffer();
        for (String element : collection) {
            sb.append(element);
            sb.append("\n");
        }
        WriteFileUtils.writeStringToFile(output, sb.toString(), encoding);
    }

    public static List<Map<String, String>> getCvsAsListMap(File input) throws IOException {
        List<String[]> lines = CsvFileUtils.readFileToList(input, ";", "UTF-8");
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        String[] headline = lines.remove(0);
        int i = 0;
        while (i < lines.size()) {
            LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
            String[] line = lines.get(i);
            int j = 0;
            while (j < line.length) {
                context.put(headline[j], line[j]);
                ++j;
            }
            data.add(context);
            ++i;
        }
        return data;
    }
}

