/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.create;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.sourceforge.jaulp.file.exceptions.DirectoryAllreadyExistsException;
import org.apache.log4j.Logger;

public final class CreateFileUtils {
    private static final Logger logger = Logger.getLogger((String)CreateFileUtils.class.getName());

    private CreateFileUtils() {
    }

    public static boolean newDirectory(File dir) throws DirectoryAllreadyExistsException {
        boolean created = false;
        if (dir.exists()) {
            throw new DirectoryAllreadyExistsException("Directory allready exists.");
        }
        created = dir.mkdir();
        return created;
    }

    public static boolean newDirectoryQuietly(File dir) {
        try {
            return CreateFileUtils.newDirectory(dir);
        }
        catch (DirectoryAllreadyExistsException e) {
            logger.error((Object)("Directory '" + dir.getAbsolutePath() + "' allready exists."), (Throwable)e);
            return false;
        }
    }

    public static boolean newDirectoriesQuietly(Collection<File> directories) {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileUtils.newDirectoryQuietly(dir);
        }
        return created;
    }

    public static boolean newDirectories(Collection<File> directories) throws DirectoryAllreadyExistsException {
        boolean created = false;
        for (File dir : directories) {
            created = CreateFileUtils.newDirectory(dir);
        }
        return created;
    }

    public static boolean newFile(File file) throws IOException {
        boolean created = false;
        if (!file.exists()) {
            CreateFileUtils.newParentDirectories(file);
            created = file.createNewFile();
        } else {
            created = true;
        }
        return created;
    }

    public static void newParentDirectories(File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public static boolean newFileQuietly(File file) {
        try {
            return CreateFileUtils.newFile(file);
        }
        catch (IOException e) {
            logger.error((Object)("File '" + file.getAbsolutePath() + "' could not created. For more information see the exception:"), (Throwable)e);
            return false;
        }
    }

    public static boolean newFiles(Collection<File> files) throws IOException {
        boolean created = false;
        for (File file : files) {
            created = CreateFileUtils.newFile(file);
        }
        return created;
    }
}

