/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.copy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.jaulp.file.FileExtension;
import net.sourceforge.jaulp.file.create.CreateFileUtils;
import net.sourceforge.jaulp.file.exceptions.DirectoryAllreadyExistsException;
import net.sourceforge.jaulp.file.exceptions.FileIsADirectoryException;
import net.sourceforge.jaulp.file.exceptions.FileIsNotADirectoryException;
import net.sourceforge.jaulp.file.exceptions.FileIsSecurityRestrictedException;
import net.sourceforge.jaulp.io.StreamUtils;

public final class CopyFileUtils {
    private CopyFileUtils() {
    }

    public static boolean copyFile(File source, File destination) throws IOException, FileIsADirectoryException {
        return CopyFileUtils.copyFile(source, destination, true);
    }

    public static boolean copyFile(File source, File destination, boolean lastModified) throws IOException, FileIsADirectoryException {
        return CopyFileUtils.copyFile(source, destination, null, null, lastModified);
    }

    public static boolean copyFile(File source, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) throws IOException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("The source File " + destination.getName() + " should be a File but is a Directory.");
        }
        if (destination.isDirectory()) {
            throw new IllegalArgumentException("The destination File " + destination.getName() + " should be a File but is a Directory.");
        }
        boolean copied = false;
        InputStream inputStream = StreamUtils.getInputStream((File)source);
        InputStreamReader reader = sourceEncoding != null ? new InputStreamReader(inputStream, sourceEncoding) : new InputStreamReader(inputStream);
        OutputStream outputStream = StreamUtils.getOutputStream((File)destination, (!destination.exists() ? 1 : 0) != 0);
        char[] charArray = new char[8192];
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        OutputStreamWriter writer = destinationEncoding != null ? new OutputStreamWriter((OutputStream)bos, destinationEncoding) : new OutputStreamWriter(bos);
        try {
            int tmp;
            while ((tmp = reader.read(charArray)) > 0) {
                writer.write(charArray, 0, tmp);
            }
            copied = true;
        }
        finally {
            StreamUtils.closeReader((Reader)reader);
            StreamUtils.closeWriter((Writer)writer);
        }
        if (lastModified) {
            destination.setLastModified(source.lastModified());
        }
        return copied;
    }

    public static File newBackupOf(File file, Charset sourceEncoding, Charset destinationEncoding) throws IOException {
        File backup = new File(String.valueOf(file.getAbsolutePath()) + FileExtension.BACKUP.getExtension());
        CopyFileUtils.copyFile(file, backup, sourceEncoding, destinationEncoding, true);
        return backup;
    }

    public static boolean copyDirectory(File source, File destination) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAllreadyExistsException {
        return CopyFileUtils.copyDirectory(source, destination, true);
    }

    public static boolean copyDirectory(File source, File destination, boolean lastModified) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAllreadyExistsException {
        return CopyFileUtils.copyDirectoryWithFileFilter(source, destination, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter fileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAllreadyExistsException {
        return CopyFileUtils.copyDirectoryWithFileFilter(source, destination, fileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAllreadyExistsException {
        return CopyFileUtils.copyDirectoryWithFileFilter(source, destination, includeFileFilter, excludeFileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, Collection<File> excludeFiles, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAllreadyExistsException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            CreateFileUtils.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = includeFileFilter != null ? source.listFiles(includeFileFilter) : source.listFiles();
        if (includeFilesArray != null) {
            File[] excludeFilesArray = null;
            ArrayList<File> allExcludeFilesList = null;
            List<File> excludeFileFilterList = null;
            if (excludeFileFilter != null) {
                excludeFilesArray = source.listFiles(excludeFileFilter);
                excludeFileFilterList = Arrays.asList(excludeFilesArray);
                allExcludeFilesList = new ArrayList<File>(excludeFileFilterList);
            }
            if (excludeFiles != null && !excludeFiles.isEmpty()) {
                if (allExcludeFilesList != null) {
                    allExcludeFilesList.addAll(excludeFiles);
                } else {
                    allExcludeFilesList = new ArrayList<File>(excludeFiles);
                }
            }
            if (allExcludeFilesList != null && !allExcludeFilesList.isEmpty()) {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (!allExcludeFilesList.contains(currentFile)) {
                        File copy = new File(destination, currentFile.getName());
                        copied = currentFile.isDirectory() ? CopyFileUtils.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileUtils.copyFile(currentFile, copy, lastModified);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileUtils.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileUtils.copyFile(currentFile, copy, lastModified);
                    ++i;
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAllreadyExistsException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            CreateFileUtils.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = includeFilenameFilter != null ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (includeFilesArray != null) {
            File[] excludeFilesArray = null;
            List<File> excludeFilesList = null;
            if (excludeFilenameFilter != null) {
                excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (excludeFilesList != null && !excludeFilesList.isEmpty()) {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    if (!excludeFilesList.contains(currentFile)) {
                        File copy = new File(destination, currentFile.getName());
                        copied = currentFile.isDirectory() ? CopyFileUtils.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileUtils.copyFile(currentFile, copy, lastModified);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < includeFilesArray.length) {
                    File currentFile = includeFilesArray[i];
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileUtils.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileUtils.copyFile(currentFile, copy, lastModified);
                    ++i;
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter filenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAllreadyExistsException {
        return CopyFileUtils.copyDirectoryWithFilenameFilter(source, destination, filenameFilter, null, lastModified);
    }

    public static boolean copyFileToDirectory(File source, File destinationDir) throws FileIsNotADirectoryException, IOException, FileIsADirectoryException {
        return CopyFileUtils.copyFileToDirectory(source, destinationDir, true);
    }

    public static boolean copyFileToDirectory(File source, File destinationDir, boolean lastModified) throws FileIsNotADirectoryException, IOException, FileIsADirectoryException {
        if (destinationDir == null) {
            throw new IllegalArgumentException("Destination must not be null");
        }
        if (!destinationDir.isDirectory()) {
            throw new FileIsNotADirectoryException("Destination File-object '" + destinationDir.getAbsolutePath() + "' is not a directory.");
        }
        File destinationFile = new File(destinationDir, source.getName());
        return CopyFileUtils.copyFile(source, destinationFile, lastModified);
    }
}

