/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.compare;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jaulp.file.FileUtils;
import net.sourceforge.jaulp.file.checksum.Algorithm;
import net.sourceforge.jaulp.file.checksum.ChecksumUtils;
import net.sourceforge.jaulp.file.compare.FileCompareResultBean;
import net.sourceforge.jaulp.file.compare.FileContentResultBean;
import net.sourceforge.jaulp.file.compare.interfaces.IFileCompareResultBean;
import net.sourceforge.jaulp.file.compare.interfaces.IFileContentResultBean;
import net.sourceforge.jaulp.file.search.FileSearchUtils;
import net.sourceforge.jaulp.io.StreamUtils;

public final class CompareFileUtils {
    private CompareFileUtils() {
    }

    public static IFileContentResultBean compareFileContentByBytes(File sourceFile, File fileToCompare) {
        boolean contentEquality;
        FileContentResultBean fileContentResultBean;
        block11: {
            fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
            CompareFileUtils.completeCompare(fileContentResultBean);
            boolean simpleEquality = CompareFileUtils.validateEquality(fileContentResultBean);
            contentEquality = true;
            if (simpleEquality) {
                InputStream sourceReader = null;
                InputStream compareReader = null;
                try {
                    sourceReader = StreamUtils.getInputStream((File)sourceFile);
                    compareReader = StreamUtils.getInputStream((File)fileToCompare);
                    byte[] source = StreamUtils.getByteArray((InputStream)sourceReader);
                    byte[] compare = StreamUtils.getByteArray((InputStream)compareReader);
                    int i = 0;
                    while (source.length > 0) {
                        if (source[i] != compare[i]) {
                            contentEquality = false;
                            break;
                        }
                        ++i;
                    }
                }
                catch (FileNotFoundException e) {
                    contentEquality = false;
                    StreamUtils.closeInputStream((InputStream)sourceReader);
                    StreamUtils.closeInputStream((InputStream)compareReader);
                    break block11;
                }
                catch (IOException e) {
                    try {
                        contentEquality = false;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        StreamUtils.closeInputStream((InputStream)sourceReader);
                        StreamUtils.closeInputStream((InputStream)compareReader);
                    }
                }
                StreamUtils.closeInputStream((InputStream)sourceReader);
                StreamUtils.closeInputStream((InputStream)compareReader);
            }
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    public static IFileContentResultBean compareFileContentByLines(File sourceFile, File fileToCompare) {
        boolean contentEquality;
        FileContentResultBean fileContentResultBean;
        block9: {
            fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
            CompareFileUtils.completeCompare(fileContentResultBean);
            boolean simpleEquality = CompareFileUtils.validateEquality(fileContentResultBean);
            contentEquality = true;
            if (simpleEquality) {
                BufferedReader sourceReader = null;
                BufferedReader compareReader = null;
                try {
                    String sourceLine;
                    sourceReader = (BufferedReader)StreamUtils.getReader((File)sourceFile);
                    compareReader = (BufferedReader)StreamUtils.getReader((File)fileToCompare);
                    while ((sourceLine = sourceReader.readLine()) != null) {
                        String compareLine = compareReader.readLine();
                        if (compareLine != null && sourceLine.equals(compareLine)) continue;
                        contentEquality = false;
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    contentEquality = false;
                    StreamUtils.closeReader((Reader)sourceReader);
                    StreamUtils.closeReader((Reader)compareReader);
                    break block9;
                }
                catch (IOException e) {
                    try {
                        contentEquality = false;
                    }
                    catch (Throwable throwable) {
                        StreamUtils.closeReader(sourceReader);
                        StreamUtils.closeReader(compareReader);
                        throw throwable;
                    }
                    StreamUtils.closeReader((Reader)sourceReader);
                    StreamUtils.closeReader((Reader)compareReader);
                    break block9;
                }
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    public static boolean compareFiles(File source, File compare, boolean content) {
        boolean equal;
        block12: {
            equal = true;
            boolean sameFilename = false;
            if (!source.exists()) {
                return !compare.exists() && (sameFilename = source.getName().equals(compare.getName()));
            }
            if (!compare.exists()) {
                return false;
            }
            if (source.length() != compare.length()) {
                return false;
            }
            if (content) {
                BufferedReader sourceReader = null;
                BufferedReader compareReader = null;
                try {
                    String sourceLine;
                    sourceReader = (BufferedReader)StreamUtils.getReader((File)source);
                    compareReader = (BufferedReader)StreamUtils.getReader((File)compare);
                    while ((sourceLine = sourceReader.readLine()) != null) {
                        String compareLine = compareReader.readLine();
                        if (compareLine != null && sourceLine.equals(compareLine)) continue;
                        equal = false;
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    equal = false;
                    StreamUtils.closeReader((Reader)sourceReader);
                    StreamUtils.closeReader((Reader)compareReader);
                    break block12;
                }
                catch (IOException e) {
                    try {
                        equal = false;
                    }
                    catch (Throwable throwable) {
                        StreamUtils.closeReader(sourceReader);
                        StreamUtils.closeReader(compareReader);
                        throw throwable;
                    }
                    StreamUtils.closeReader((Reader)sourceReader);
                    StreamUtils.closeReader((Reader)compareReader);
                    break block12;
                }
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
        }
        return equal;
    }

    public static void completeCompare(IFileCompareResultBean fileCompareResultBean) {
        CompareFileUtils.compare(fileCompareResultBean, false, false, false, false, false);
    }

    public static void compare(IFileCompareResultBean fileCompareResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        File source = fileCompareResultBean.getSourceFile();
        File compare = fileCompareResultBean.getFileToCompare();
        if (!ignoreAbsolutePathEquality) {
            String sourceAbsolutePath = source.getAbsolutePath();
            String compareAbsolutePath = compare.getAbsolutePath();
            boolean absolutePathEquality = sourceAbsolutePath.equals(compareAbsolutePath);
            fileCompareResultBean.setAbsolutePathEquality(absolutePathEquality);
        } else {
            fileCompareResultBean.setAbsolutePathEquality(true);
        }
        if (!ignoreExtensionEquality) {
            String sourceFileExtension = FileUtils.getFilenameSuffix(source);
            String compareFileExtension = FileUtils.getFilenameSuffix(compare);
            boolean extensionEquality = compareFileExtension.equalsIgnoreCase(sourceFileExtension);
            fileCompareResultBean.setFileExtensionEquality(extensionEquality);
        } else {
            fileCompareResultBean.setFileExtensionEquality(true);
        }
        if (!ignoreLengthEquality) {
            boolean length = source.length() == compare.length();
            fileCompareResultBean.setLengthEquality(length);
        } else {
            fileCompareResultBean.setLengthEquality(true);
        }
        if (!ignoreLastModified) {
            boolean lastModified = source.lastModified() == compare.lastModified();
            fileCompareResultBean.setLastModifiedEquality(lastModified);
        } else {
            fileCompareResultBean.setLastModifiedEquality(true);
        }
        if (!ignoreNameEquality) {
            String sourceFilename = FileUtils.getFilenameWithoutExtension(source);
            String compareFilename = FileUtils.getFilenameWithoutExtension(compare);
            boolean nameEquality = compareFilename.equalsIgnoreCase(sourceFilename);
            fileCompareResultBean.setNameEquality(nameEquality);
        } else {
            fileCompareResultBean.setNameEquality(true);
        }
    }

    public static void compare(IFileContentResultBean fileContentResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        CompareFileUtils.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        File source = fileContentResultBean.getSourceFile();
        File compare = fileContentResultBean.getFileToCompare();
        if (!ignoreContentEquality) {
            try {
                String sourceChecksum = ChecksumUtils.getChecksum(source, Algorithm.SHA_512.getAlgorithm());
                String compareChecksum = ChecksumUtils.getChecksum(compare, Algorithm.SHA_512.getAlgorithm());
                boolean contentEquality = sourceChecksum.equals(compareChecksum);
                fileContentResultBean.setContentEquality(contentEquality);
            }
            catch (NoSuchAlgorithmException e) {
                boolean contentEquality = ChecksumUtils.getCheckSumCRC32(source) == ChecksumUtils.getCheckSumCRC32(compare);
                fileContentResultBean.setContentEquality(contentEquality);
            }
        } else {
            fileContentResultBean.setContentEquality(true);
        }
    }

    public static IFileCompareResultBean simpleCompareFiles(File sourceFile, File fileToCompare) {
        return CompareFileUtils.compareFiles(sourceFile, fileToCompare, true, false, false, true, false);
    }

    public static IFileCompareResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        FileCompareResultBean fileCompareResultBean = new FileCompareResultBean(sourceFile, fileToCompare);
        CompareFileUtils.compare(fileCompareResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        return fileCompareResultBean;
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare) {
        return CompareFileUtils.compareFiles(sourceFile, fileToCompare, true, false, false, true, false, true);
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileUtils.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality);
        return fileContentResultBean;
    }

    public static boolean validateEquality(IFileCompareResultBean fileCompareResultBean) {
        return fileCompareResultBean.getFileExtensionEquality() && fileCompareResultBean.getLengthEquality() && fileCompareResultBean.getLastModifiedEquality() && fileCompareResultBean.getNameEquality();
    }

    public static boolean validateEquality(IFileContentResultBean fileContentResultBean) {
        return fileContentResultBean.getFileExtensionEquality() && fileContentResultBean.getLengthEquality() && fileContentResultBean.getLastModifiedEquality() && fileContentResultBean.getNameEquality() && fileContentResultBean.getContentEquality();
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch) {
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        int i = 0;
        while (i < allFiles.size()) {
            File toCompare = allFiles.get(i);
            int j = 0;
            while (j < allFiles.size()) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.simpleCompareFiles(toCompare, file))) && !equalFiles.contains(compareResultBean)) {
                    equalFiles.add(compareResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        int i = 0;
        while (i < allFiles.size()) {
            File toCompare = allFiles.get(i);
            int j = 0;
            while (j < allFiles.size()) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) && !equalFiles.contains(compareResultBean)) {
                    equalFiles.add(compareResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        int i = 0;
        while (i < allSourceFiles.size()) {
            File toCompare = allSourceFiles.get(i);
            int j = 0;
            while (j < allCompareFiles.size()) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.simpleCompareFiles(toCompare, file))) && !equalFiles.contains(compareResultBean)) {
                    equalFiles.add(compareResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        int i = 0;
        while (i < allSourceFiles.size()) {
            File toCompare = allSourceFiles.get(i);
            int j = 0;
            while (j < allCompareFiles.size()) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) && !equalFiles.contains(compareResultBean)) {
                    equalFiles.add(compareResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        int i = 0;
        while (i < allFiles.size()) {
            File toCompare = allFiles.get(i);
            int j = 0;
            while (j < allFiles.size()) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file))) && !equalFiles.contains(contentResultBean)) {
                    equalFiles.add(contentResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        int i = 0;
        while (i < allFiles.size()) {
            File toCompare = allFiles.get(i);
            int j = 0;
            while (j < allFiles.size()) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) && !equalFiles.contains(contentResultBean)) {
                    equalFiles.add(contentResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        int i = 0;
        while (i < allSourceFiles.size()) {
            File toCompare = allSourceFiles.get(i);
            int j = 0;
            while (j < allCompareFiles.size()) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file))) && !equalFiles.contains(contentResultBean)) {
                    equalFiles.add(contentResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        int i = 0;
        while (i < allSourceFiles.size()) {
            File toCompare = allSourceFiles.get(i);
            int j = 0;
            while (j < allCompareFiles.size()) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (!toCompare.equals(file) && (equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) && !equalFiles.contains(contentResultBean)) {
                    equalFiles.add(contentResultBean);
                }
                ++j;
            }
            ++i;
        }
        return equalFiles;
    }
}

