/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.sourceforge.jaulp.file.checksum.Algorithm;
import net.sourceforge.jaulp.file.read.ReadFileUtils;
import net.sourceforge.jaulp.io.StreamUtils;
import org.apache.commons.lang.ArrayUtils;

public final class ChecksumUtils {
    static final Logger LOGGER = Logger.getLogger(ChecksumUtils.class.getName());

    private static void checkWithByteArray(byte[] ba) throws NoSuchAlgorithmException {
        Algorithm[] algorithms = Algorithm.values();
        int i = 0;
        while (i < algorithms.length) {
            try {
                String result = ChecksumUtils.getChecksum(ba, algorithms[i].getAlgorithm());
                System.out.println("getChecksum from " + algorithms[i] + " algorithm:\t\t" + result);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            ++i;
        }
    }

    private static void checkWithFile(File pom) throws NoSuchAlgorithmException {
        Algorithm[] algorithms = Algorithm.values();
        int i = 0;
        while (i < algorithms.length) {
            try {
                String result = ChecksumUtils.getChecksum(pom, algorithms[i].getAlgorithm());
                System.out.println("getChecksum from " + algorithms[i] + " algorithm:\t\t" + result);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static String getChecksum(byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumUtils.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(Byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumUtils.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        messageDigest.update(bytes);
        byte[] digest = messageDigest.digest();
        StringBuilder hexView = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            String intAsHex = Integer.toHexString(0xFF & digest[i]);
            if (intAsHex.length() == 1) {
                hexView.append('0');
            }
            hexView.append(intAsHex);
            ++i;
        }
        return hexView.toString();
    }

    public static String getChecksum(Byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ChecksumUtils.getChecksum(ArrayUtils.toPrimitive((Byte[])bytes), algorithm);
    }

    public static String getChecksum(File file, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumUtils.getChecksum(file, algorithm.getAlgorithm());
    }

    public static long getChecksum(File file, boolean crc) throws FileNotFoundException, IOException {
        CheckedInputStream cis = null;
        cis = crc ? new CheckedInputStream(new FileInputStream(file), new CRC32()) : new CheckedInputStream(new FileInputStream(file), new Adler32());
        int length = (int)file.length();
        byte[] buffer = new byte[length];
        long checksum = 0L;
        while (cis.read(buffer) >= 0) {
            checksum = cis.getChecksum().getValue();
        }
        checksum = cis.getChecksum().getValue();
        StreamUtils.closeInputStream((InputStream)cis);
        return checksum;
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException {
        return ChecksumUtils.getChecksum(ReadFileUtils.toByteArray(file), algorithm);
    }

    public static long getCheckSumAdler32(byte[] bytes) {
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumAdler32(File file) {
        return ChecksumUtils.getCheckSumAdler32(ReadFileUtils.toByteArray(file));
    }

    public static long getCheckSumCRC32(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumCRC32(File file) {
        return ChecksumUtils.getCheckSumCRC32(ReadFileUtils.toByteArray(file));
    }

    public static String getChecksumQuietly(byte[] bytes, Algorithm algorithm) {
        try {
            return ChecksumUtils.getChecksum(bytes, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "getChecksumQuietly failed...\n" + e.getMessage(), e);
            return null;
        }
    }

    public static String getChecksumQuietly(byte[] bytes, String algorithm) {
        try {
            return ChecksumUtils.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "getChecksumQuietly failed...\n" + e.getMessage(), e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(Byte[] bytes, String algorithm) {
        try {
            return ChecksumUtils.getChecksum(bytes, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "getChecksumQuietly failed...\n" + e.getMessage(), e);
            return algorithm;
        }
    }

    public static String getChecksumQuietly(File file, Algorithm algorithm) {
        try {
            return ChecksumUtils.getChecksum(file, algorithm.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "getChecksumQuietly failed...\n" + e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        if (args.length != 1) {
            System.err.println("Usage: java ChecksumCRC32 filename");
        } else {
            File pom = new File(args[0]);
            ChecksumUtils.checkWithFile(pom);
            long checksum = ChecksumUtils.getChecksum(new File(args[0]), true);
            System.out.println("CRC32 checksum:" + checksum);
            checksum = ChecksumUtils.getChecksum(new File(args[0]), false);
            System.out.println("Adler32 checksum:" + checksum);
            byte[] ba = ReadFileUtils.readFileToBytearray(pom);
            ChecksumUtils.checkWithByteArray(ba);
        }
    }

    private ChecksumUtils() {
    }
}

