/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file;

import java.util.ArrayList;
import java.util.List;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static String newcreateStaticArrayVariable(String arrayName, List<String> data) {
        StringBuffer sb = new StringBuffer();
        sb.append("public static final String []");
        sb.append(arrayName.trim().toUpperCase());
        sb.append(" = {");
        int size = data.size();
        int i = 0;
        while (i < size) {
            String element = data.get(i);
            if (i < size - 1) {
                sb.append("\"" + element + "\", ");
            } else {
                sb.append("\"" + element + "\"");
            }
            ++i;
        }
        sb.append("};");
        return sb.toString();
    }

    public static List<String> newConstantsFromStringList(List<String> data, String prefix, String suffix, boolean withQuotation) {
        ArrayList<String> returnList = new ArrayList<String>();
        int size = data.size();
        int i = 0;
        while (i < size) {
            String element = data.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append("public static final String ");
            if (withQuotation) {
                String striped = element.trim().toUpperCase();
                striped = striped.substring(1, striped.length() - 1);
                if (prefix != null) {
                    sb.append(prefix.toUpperCase());
                }
                sb.append(striped);
                if (suffix != null) {
                    sb.append(suffix.toUpperCase());
                }
                sb.append(" = ");
                sb.append(String.valueOf(element) + ";");
            } else {
                if (prefix != null) {
                    sb.append(prefix.toUpperCase());
                }
                sb.append(element.trim().toUpperCase());
                if (suffix != null) {
                    sb.append(suffix.toUpperCase());
                }
                sb.append(" = ");
                sb.append("\"" + element + "\";");
            }
            returnList.add(sb.toString().trim());
            ++i;
        }
        return returnList;
    }
}

