/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileLock;
import net.sourceforge.jaulp.file.FilenameUtils;
import net.sourceforge.jaulp.file.read.ReadFileUtils;
import net.sourceforge.jaulp.file.rename.RenameFileUtils;
import org.apache.log4j.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger((String)FileUtils.class.getName());

    private FileUtils() {
    }

    public static byte[] download(URI uri) {
        File tmpFile = new File(uri);
        return ReadFileUtils.toByteArray(tmpFile);
    }

    public static String getAbsolutPathWithoutFilename(File file) {
        return RenameFileUtils.getAbsolutPathWithoutFilename(file);
    }

    public static String getCurrentAbsolutPathWithoutDotAndSlash() {
        File currentAbsolutPath = new File(".");
        return currentAbsolutPath.getAbsolutePath().substring(0, currentAbsolutPath.getAbsolutePath().length() - 2);
    }

    public static String getFilenamePrefix(File file) {
        return FilenameUtils.getFilenamePrefix((File)file);
    }

    public static String getFilenameWithoutExtension(File file) {
        return FilenameUtils.getFilenameWithoutExtension((File)file);
    }

    public static String getFilenameSuffix(File file) {
        return FilenameUtils.getFilenameSuffix((File)file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOpen(File file) {
        boolean open = false;
        RandomAccessFile fileAccess = null;
        FileLock lock = null;
        try {
            try {
                fileAccess = new RandomAccessFile(file.getAbsolutePath(), "rw");
                lock = fileAccess.getChannel().tryLock();
                if (lock == null) {
                    open = true;
                    return open;
                } else {
                    lock.release();
                }
                return open;
            }
            catch (FileNotFoundException fnfe) {
                open = true;
                if (fileAccess == null) return open;
                try {
                    fileAccess.close();
                    fileAccess = null;
                    return open;
                }
                catch (IOException ioex) {
                    LOGGER.error((Object)ioex);
                }
                return open;
            }
            catch (IOException ioe) {
                open = true;
                if (fileAccess == null) return open;
                try {
                    fileAccess.close();
                    fileAccess = null;
                    return open;
                }
                catch (IOException ioex) {
                    LOGGER.error((Object)ioex);
                }
                return open;
            }
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.close();
                    fileAccess = null;
                }
                catch (IOException ioex) {
                    LOGGER.error((Object)ioex);
                }
            }
        }
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

