/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.export.excel.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;

public final class ExportExcelUtils {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        String filename = null;
        String filePath = null;
        String relativeFilename = null;
        File currentPath = new File(".");
        filePath = "/jexcelFiles/xls/";
        filename = "testing.xls";
        relativeFilename = String.valueOf(filePath) + filename;
        File excelSheet = new File(currentPath, relativeFilename);
        ExportExcelUtils.saveWorkbook(excelSheet);
    }

    private ExportExcelUtils() {
    }

    public static List<String[][]> exportWorkbook(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<String[][]> sheetList = new ArrayList<String[][]>();
        int sheetNumber = 0;
        while (sheetNumber < numberOfSheets) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            String[][] excelSheetInTDArray = null;
            excelSheetInTDArray = new String[rows][columns];
            int i = 0;
            while (i < rows) {
                HSSFRow row = sheet.getRow(i);
                if (row != null) {
                    int j = 0;
                    while (j < columns) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            excelSheetInTDArray[i][j] = "";
                        } else {
                            int cellType = cell.getCellType();
                            if (cellType == 3) {
                                excelSheetInTDArray[i][j] = "";
                            } else if (cellType == 4) {
                                excelSheetInTDArray[i][j] = new Boolean(cell.getBooleanCellValue()).toString();
                            } else if (cellType == 5) {
                                excelSheetInTDArray[i][j] = "";
                            } else if (cellType == 2) {
                                excelSheetInTDArray[i][j] = cell.getCellFormula();
                            } else if (cellType == 0) {
                                excelSheetInTDArray[i][j] = new Double(cell.getNumericCellValue()).toString();
                            } else if (cellType == 1) {
                                excelSheetInTDArray[i][j] = cell.getRichStringCellValue().getString();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            sheetList.add(excelSheetInTDArray);
            ++sheetNumber;
        }
        return sheetList;
    }

    public static List<List<List<String>>> exportWorkbookAsStringList(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<List<List<String>>> sl = new ArrayList<List<List<String>>>();
        int sheetNumber = 0;
        while (sheetNumber < numberOfSheets) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            ArrayList excelSheetList = new ArrayList();
            int i = 0;
            while (i < rows) {
                HSSFRow row = sheet.getRow(i);
                if (row != null) {
                    ArrayList<String> reihe = new ArrayList<String>();
                    int j = 0;
                    while (j < columns) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            reihe.add("");
                        } else {
                            int cellType = cell.getCellType();
                            if (cellType == 3) {
                                reihe.add("");
                            } else if (cellType == 4) {
                                reihe.add(new Boolean(cell.getBooleanCellValue()).toString());
                            } else if (cellType == 5) {
                                reihe.add("");
                            } else if (cellType == 2) {
                                reihe.add(cell.getCellFormula());
                            } else if (cellType == 0) {
                                reihe.add(new Double(cell.getNumericCellValue()).toString());
                            } else if (cellType == 1) {
                                reihe.add(cell.getRichStringCellValue().getString());
                            }
                        }
                        ++j;
                    }
                    excelSheetList.add(reihe);
                }
                ++i;
            }
            sl.add(excelSheetList);
            ++sheetNumber;
        }
        return sl;
    }

    public static HSSFWorkbook replaceNullCellsIntoEmptyCells(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        int sheetNumber = 0;
        while (sheetNumber < numberOfSheets) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            int i = 0;
            while (i < rows) {
                HSSFRow row = sheet.getRow(i);
                if (row != null) {
                    int j = 0;
                    while (j < columns) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            cell = row.createCell(j, 3);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++sheetNumber;
        }
        return wb;
    }

    public static void saveWorkbook(File excelSheet) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(excelSheet);
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        int sheetNumber = 0;
        while (sheetNumber < numberOfSheets) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            int i = 0;
            while (i < rows) {
                HSSFRow row = sheet.getRow(i);
                if (row != null) {
                    int j = 0;
                    while (j < columns) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            cell = row.createCell(j);
                            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++sheetNumber;
        }
        wb.write((OutputStream)out);
        out.close();
    }

    public static CellStyle newDateCellStyle(Workbook workbook, String dateFormat) {
        CellStyle dateCellStyle = workbook.createCellStyle();
        dateCellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(dateFormat));
        return dateCellStyle;
    }

    public static CellStyle newCellStyle(Workbook workbook, String fontName, short boldweight, short height) {
        CellStyle boldFontCellStyle = workbook.createCellStyle();
        boldFontCellStyle.setFont(ExportExcelUtils.newFont(workbook, fontName, boldweight, height));
        return boldFontCellStyle;
    }

    public static Font newFont(Workbook workbook, String fontName, short boldweight, short height) {
        Font font = workbook.createFont();
        font.setFontName(fontName);
        font.setBoldweight(boldweight);
        font.setFontHeightInPoints(height);
        return font;
    }
}

