/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.zip;

import java.io.File;
import java.io.FilenameFilter;
import java.util.zip.ZipFile;

/**
 * The Interface ZipModel.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public interface ZipModel
{

	/**
	 * Returns the field <code>compressionMethod</code>.
	 * 
	 * @return The field <code>compressionMethod</code>.
	 */
	public int getCompressionMethod();

	/**
	 * Returns the field <code>directoryToZip</code>.
	 * 
	 * @return The field <code>directoryToZip</code>.
	 */
	public File getDirectoryToZip();

	/**
	 * Returns the field <code>dirToStart</code>.
	 * 
	 * @return The field <code>dirToStart</code>.
	 */
	public String getDirToStart();

	/**
	 * Returns the field <code>fileCounter</code>.
	 * 
	 * @return The field <code>fileCounter</code>.
	 */
	public int getFileCounter();

	/**
	 * Returns the field <code>fileFilter</code>.
	 * 
	 * @return The field <code>fileFilter</code>.
	 */
	public FilenameFilter getFileFilter();

	/**
	 * Returns the field <code>fileLength</code>.
	 * 
	 * @return The field <code>fileLength</code>.
	 */
	public long getFileLength();

	/**
	 * Returns the field <code>zipFile</code>.
	 * 
	 * @return The field <code>zipFile</code>.
	 */
	public File getZipFile();

	/**
	 * Returns the field <code>zipFileComment</code>.
	 * 
	 * @return The field <code>zipFileComment</code>.
	 */
	public String getZipFileComment();

	/**
	 * Returns the field <code>zipFileName</code>.
	 * 
	 * @return The field <code>zipFileName</code>.
	 */
	public String getZipFileName();

	/**
	 * Returns the field <code>zipFileObj</code>.
	 * 
	 * @return The field <code>zipFileObj</code>.
	 */
	public ZipFile getZipFileObj();

	/**
	 * Returns the field <code>zipLevel</code>.
	 * 
	 * @return The field <code>zipLevel</code>.
	 */
	public int getZipLevel();

	/**
	 * Sets the field <code>compressionMethod</code>.
	 * 
	 * @param compressionMethod
	 *            The <code>compressionMethod</code> to set
	 */
	public void setCompressionMethod(int compressionMethod);

	/**
	 * Sets the field <code>directoryToZip</code>.
	 * 
	 * @param directoryToZip
	 *            The <code>directoryToZip</code> to set
	 */
	public void setDirectoryToZip(File directoryToZip);

	/**
	 * Sets the field <code>dirToStart</code>.
	 * 
	 * @param dirToStart
	 *            The <code>dirToStart</code> to set
	 */
	public void setDirToStart(String dirToStart);

	/**
	 * Sets the field <code>fileCounter</code>.
	 * 
	 * @param fileCounter
	 *            The <code>fileCounter</code> to set
	 */
	public void setFileCounter(int fileCounter);

	/**
	 * Sets the field <code>fileFilter</code>.
	 * 
	 * @param fileFilter
	 *            The <code>fileFilter</code> to set
	 */
	public void setFileFilter(FilenameFilter fileFilter);

	/**
	 * Sets the field <code>fileLength</code>.
	 * 
	 * @param fileLength
	 *            The <code>fileLength</code> to set
	 */
	public void setFileLength(long fileLength);

	/**
	 * Sets the field <code>zipFile</code>.
	 * 
	 * @param zipFile
	 *            The <code>zipFile</code> to set
	 */
	public void setZipFile(File zipFile);

	/**
	 * Sets the field <code>zipFileComment</code>.
	 * 
	 * @param zipFileComment
	 *            The <code>zipFileComment</code> to set
	 */
	public void setZipFileComment(String zipFileComment);

	/**
	 * Sets the field <code>zipFileName</code>.
	 * 
	 * @param zipFileName
	 *            The <code>zipFileName</code> to set
	 */
	public void setZipFileName(String zipFileName);

	/**
	 * Sets the field <code>zipFileObj</code>.
	 * 
	 * @param zipFileObj
	 *            The <code>zipFileObj</code> to set
	 */
	public void setZipFileObj(ZipFile zipFileObj);

	/**
	 * Sets the field <code>zipLevel</code>.
	 * 
	 * @param zipLevel
	 *            The <code>zipLevel</code> to set
	 */
	public void setZipLevel(int zipLevel);

}