/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.url;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

/**
 * The Class URLUtils.
 */
public class URLUtils
{

	/**
	 * Checks if is jar.
	 * 
	 * @param url
	 *            the url
	 * @return true, if is jar
	 */
	public boolean isJar(URL url)
	{
		return url.getProtocol().equals(Protocol.JAR.getProtocol());
	}

	/**
	 * Checks if is ear.
	 * 
	 * @param url
	 *            the url
	 * @return true, if is ear
	 */
	public boolean isEar(URL url)
	{
		return url.getProtocol().equals(Protocol.EAR.getProtocol());
	}

	/**
	 * Gets the filename from the given url object.
	 * 
	 * @param url
	 *            the url
	 * @return the filename
	 * @throws UnsupportedEncodingException
	 *             the unsupported encoding exception
	 */
	public String getFilename(URL url) throws UnsupportedEncodingException
	{
		if (isJar(url) || isEar(url))
		{
			String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
			fileName = fileName.substring(5, fileName.indexOf("!"));
			return fileName;
		}
		return URLDecoder.decode(url.getFile(), "UTF-8");
	}

}
