/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.url;

/**
 * The Enum Protocol represents protocols from an url.
 */
public enum Protocol
{

	/** The jar protocol. */
	JAR("jar"),
	/** The ear protocol. */
	EAR("ear");

	/**
	 * Instantiates a new protocol.
	 * 
	 * @param protocol
	 *            the protocol
	 */
	private Protocol(String protocol)
	{
		this.protocol = protocol;
	}

	/** The protocol. */
	private final String protocol;

	/**
	 * Gets the protocol.
	 * 
	 * @return the protocol
	 */
	public String getProtocol()
	{
		return protocol;
	}
}
