/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.search;

/**
 * The Class SearchFileAttributesBean provides file attribute flags to ignore or not.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class SearchFileAttributesBean
{

	/** The ignore extension equality. */
	private final boolean ignoreExtensionEquality;

	/** The ignore length equality. */
	private final boolean ignoreLengthEquality;

	/** The ignore last modified. */
	private final boolean ignoreLastModified;

	/** The ignore name equality. */
	private final boolean ignoreNameEquality;

	/** The ignore content equality. */
	private final boolean ignoreContentEquality;

	/**
	 * Instantiates a new search file attributes bean.
	 *
	 * @param ignoreExtensionEquality
	 *            the ignore extension equality
	 * @param ignoreLengthEquality
	 *            the ignore length equality
	 * @param ignoreLastModified
	 *            the ignore last modified
	 * @param ignoreNameEquality
	 *            the ignore name equality
	 * @param ignoreContentEquality
	 *            the ignore content equality
	 */
	public SearchFileAttributesBean(boolean ignoreExtensionEquality, boolean ignoreLengthEquality,
		boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality)
	{
		super();
		this.ignoreExtensionEquality = ignoreExtensionEquality;
		this.ignoreLengthEquality = ignoreLengthEquality;
		this.ignoreLastModified = ignoreLastModified;
		this.ignoreNameEquality = ignoreNameEquality;
		this.ignoreContentEquality = ignoreContentEquality;
	}


	/**
	 * Checks if is ignore extension equality.
	 *
	 * @return true, if is ignore extension equality
	 */
	public boolean isIgnoreExtensionEquality()
	{
		return ignoreExtensionEquality;
	}

	/**
	 * Checks if is ignore length equality.
	 *
	 * @return true, if is ignore length equality
	 */
	public boolean isIgnoreLengthEquality()
	{
		return ignoreLengthEquality;
	}

	/**
	 * Checks if is ignore last modified.
	 *
	 * @return true, if is ignore last modified
	 */
	public boolean isIgnoreLastModified()
	{
		return ignoreLastModified;
	}

	/**
	 * Checks if is ignore name equality.
	 *
	 * @return true, if is ignore name equality
	 */
	public boolean isIgnoreNameEquality()
	{
		return ignoreNameEquality;
	}

	/**
	 * Checks if is ignore content equality.
	 *
	 * @return true, if is ignore content equality
	 */
	public boolean isIgnoreContentEquality()
	{
		return ignoreContentEquality;
	}

}
