/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.exceptions;

/**
 * Exception if the file could not be renamed.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public class FileNotRenamedException extends Exception
{

	/**
	 * The default serialVersionUID.
	 */
	private static final long serialVersionUID = 6852760469710242067L;

	/**
	 * Default constructor.
	 */
	public FileNotRenamedException()
	{
		super();
	}

	/**
	 * Constructs a new FileNotRenamedException with the specified detail message.
	 * 
	 * @param message
	 *            The message.
	 */
	public FileNotRenamedException(final String message)
	{
		super(message);
	}

	/**
	 * Constructs a new FileNotRenamedException with the specified detail message and the Throwable.
	 * 
	 * @param message
	 *            The message.
	 * @param cause
	 *            The Throwable.
	 */
	public FileNotRenamedException(final String message, final Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Constructs a FileNotRenamedException with the Throwable.
	 * 
	 * @param cause
	 *            The Throwable.
	 */
	public FileNotRenamedException(final Throwable cause)
	{
		super(cause);
	}

}
