/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.exceptions;

/**
 * Exception if the file or directory is security restricted.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class FileIsSecurityRestrictedException extends Exception
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 896688635590740981L;

	/**
	 * Instantiates a new file is security restricted exception.
	 */
	public FileIsSecurityRestrictedException()
	{
		super();
	}

	/**
	 * Instantiates a new file is security restricted exception.
	 *
	 * @param message
	 *            the message
	 */
	public FileIsSecurityRestrictedException(String message)
	{
		super(message);
	}

	/**
	 * Instantiates a new file is security restricted exception.
	 *
	 * @param cause
	 *            the cause
	 */
	public FileIsSecurityRestrictedException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * Instantiates a new file is security restricted exception.
	 *
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public FileIsSecurityRestrictedException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
