/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.exceptions;

/**
 * Exception if the directory has no content.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public class DirectoryHasNoContentException extends Exception
{

	/**
	 * The generated serialVersionUID.
	 */
	private static final long serialVersionUID = -5145788368840670639L;

	/**
	 * Default constructor.
	 */
	public DirectoryHasNoContentException()
	{
		super();
	}

	/**
	 * Constructs a new DirectoryHasNoContentException with the specified detail message.
	 * 
	 * @param message
	 *            The error message.
	 */
	public DirectoryHasNoContentException(final String message)
	{
		super(message);
	}

	/**
	 * Constructs a new DirectoryHasNoContentException with the specified detail message and the
	 * Throwable.
	 * 
	 * @param message
	 *            The error message.
	 * @param cause
	 *            The Throwable.
	 */
	public DirectoryHasNoContentException(final String message, final Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Constructs a DirectoryHasNoContentException with the Throwable.
	 * 
	 * @param cause
	 *            The Throwable.
	 */
	public DirectoryHasNoContentException(final Throwable cause)
	{
		super(cause);
	}

}
