/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.exceptions;

/**
 * Exception to be thrown if the directory cannot be created.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public class DirectoryCannotBeCreatedException extends Exception
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 8391789526844963655L;

	/**
	 * Instantiates a new directory cannot be created exception.
	 */
	public DirectoryCannotBeCreatedException()
	{
		super();
	}

	/**
	 * Instantiates a new directory cannot be created exception.
	 *
	 * @param message
	 *            the message
	 */
	public DirectoryCannotBeCreatedException(String message)
	{
		super(message);
	}

	/**
	 * Instantiates a new directory cannot be created exception.
	 *
	 * @param cause
	 *            the cause
	 */
	public DirectoryCannotBeCreatedException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * Instantiates a new directory cannot be created exception.
	 *
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public DirectoryCannotBeCreatedException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
