/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.compare.interfaces;

import java.io.File;

/**
 * The Interface IFileCompareResultBean.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public interface IFileCompareResultBean
{

	/**
	 * Gets the absolute path equality.
	 * 
	 * @return the absolute path equality
	 */
	boolean getAbsolutePathEquality();

	/**
	 * Gets the file extension equality.
	 * 
	 * @return the file extension equality
	 */
	boolean getFileExtensionEquality();

	/**
	 * Gets the file to compare.
	 * 
	 * @return Returns the file to compare.
	 */
	File getFileToCompare();

	/**
	 * Gets the last modified equality.
	 * 
	 * @return the last modified equality
	 */
	boolean getLastModifiedEquality();

	/**
	 * Gets the length equality.
	 * 
	 * @return the length equality
	 */
	boolean getLengthEquality();

	/**
	 * Gets the name equality.
	 * 
	 * @return the name equality
	 */
	boolean getNameEquality();

	/**
	 * Gets the source file.
	 * 
	 * @return Returns the source file.
	 */
	File getSourceFile();

	/**
	 * Sets the absolute path equality.
	 * 
	 * @param absolutePathEquality
	 *            the new absolute path equality
	 */
	void setAbsolutePathEquality(Boolean absolutePathEquality);

	/**
	 * Sets the file extension equality.
	 * 
	 * @param fileExtensionEquality
	 *            the new file extension equality
	 */
	void setFileExtensionEquality(final Boolean fileExtensionEquality);

	/**
	 * Sets the last modified equality.
	 * 
	 * @param lastModifiedEquality
	 *            the new last modified equality
	 */
	void setLastModifiedEquality(final Boolean lastModifiedEquality);

	/**
	 * Sets the length equality.
	 * 
	 * @param lengthEquality
	 *            the new length equality
	 */
	void setLengthEquality(final Boolean lengthEquality);

	/**
	 * Sets the name equality.
	 * 
	 * @param nameEquality
	 *            the new name equality
	 */
	void setNameEquality(final Boolean nameEquality);

}
