/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file.compare;

import java.io.File;

import net.sourceforge.jaulp.file.compare.interfaces.IFileContentResultBean;

/**
 * Bean that tells if the content from the given files are equal.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class FileContentResultBean extends FileCompareResultBean implements IFileContentResultBean
{

	/** The same content. */
	private Boolean contentEquality;

	/**
	 * Default constructor.
	 *
	 * @param source
	 *            the source
	 * @param compare
	 *            the compare
	 */
	public FileContentResultBean(final File source, final File compare)
	{
		super(source, compare);
	}

	/**
	 * Gets the content equality.
	 *
	 * @return the content equality {@inheritDoc}
	 * @see net.sourceforge.jaulp.file.compare.interfaces.IFileContentResultBean#getContentEquality()
	 */
	@Override
	public boolean getContentEquality()
	{
		return this.contentEquality;
	}

	/**
	 * Sets the content equality.
	 *
	 * @param contentEquality
	 *            the new content equality {@inheritDoc}
	 * @see net.sourceforge.jaulp.file.compare.interfaces.IFileContentResultBean#setContentEquality(boolean)
	 */
	@Override
	public void setContentEquality(final boolean contentEquality)
	{
		this.contentEquality = contentEquality;
	}

	/**
	 * Returns <code>true</code> if this <code>FileContentResultBean</code> is the same as the o
	 * argument.
	 *
	 * @param o
	 *            the o
	 * @return <code>true</code> if this <code>FileContentResultBean</code> is the same as the o
	 *         argument.
	 */
	@Override
	public boolean equals(Object o)
	{
		if (this == o)
		{
			return true;
		}
		if (o == null)
		{
			return false;
		}
		if (o.getClass() != getClass())
		{
			return false;
		}
		FileContentResultBean castedObj = (FileContentResultBean)o;
		FileContentResultBean other = (FileContentResultBean)o;
		if (this.compare.equals(other.source) && this.source.equals(other.compare))
		{
			return true;
		}
		if (!super.equals(o))
		{
			return false;
		}
		return this.contentEquality == null
			? castedObj.contentEquality == null
			: this.contentEquality.equals(castedObj.contentEquality);
	}

}
