/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.file;

/**
 * Constant Class for files.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public abstract class FileConst
{

	/**
	 * String array with the invalid characters in filenames.
	 */
	public static String[] INVALID_CHARS_IN_FILENAME = { "\\", "/", ":", "*", "\"", "<", ">", "|" };

	/**
	 * String array with a few extensions from zip-files.
	 */
	public static final String[] ZIP_EXTENSIONS = { ".zip", ".jar", ".war", ".ear", ".tar", ".rar",
			".7z", ".bz2", ".gz" };

	/** Constant for the blocksize. current value:8192 */
	public static final int BLOCKSIZE = 8192;

	/** Constant for the kilobyte. current value:1024 */
	public static final int KILOBYTE = 1024;

	/** Constant for the dot. current value:"." */
	public static final String DOT = ".";

	/** Constant for the dot. current value:":" */
	public static final String DOUBLEDOT = ":";

	/** Constant for the slash. current value:"/" */
	public static final String SLASH = "/";

	/** Constant for the slash. current value:"\" */
	public static final String BACKSLASH = "\\";

}
