/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.email.utils;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.sourceforge.jaulp.email.messages.EmailMessage;
import net.sourceforge.jaulp.string.StringUtils;
import org.apache.log4j.Logger;

public class EmailUtils {
    private static final Logger logger = Logger.getLogger((String)EmailUtils.class.getName());

    public static boolean validateEmailAdress(String emailAddress) {
        boolean isValid = true;
        try {
            InternetAddress internetAddress = new InternetAddress(emailAddress);
            internetAddress.validate();
        }
        catch (AddressException e) {
            isValid = false;
        }
        return isValid;
    }

    public static String getCharsetFromContentType(String type) throws MessagingException {
        int start;
        if (!StringUtils.isNullOrEmpty((String)type) && (start = type.indexOf("; charset=")) > 0) {
            int offset = type.indexOf(" ", start += "; charset=".length());
            if (offset > 0) {
                return type.substring(start, offset);
            }
            return type.substring(start);
        }
        return null;
    }

    public static Address newAddress(String emailAddress, String personal) throws AddressException, UnsupportedEncodingException {
        return EmailUtils.newAddress(emailAddress, personal, null);
    }

    public static Address[] getAddressArray(Address ... address) {
        return address;
    }

    public static Address newAddress(String address, String personal, String charset) throws AddressException, UnsupportedEncodingException {
        if (StringUtils.isNullOrEmpty((String)personal)) {
            personal = address;
        }
        InternetAddress internetAdress = new InternetAddress(address);
        if (StringUtils.isNullOrEmpty((String)charset)) {
            internetAdress.setPersonal(personal);
        } else {
            internetAdress.setPersonal(personal, charset);
        }
        return internetAdress;
    }

    public static Address newAddress(String address) throws AddressException, UnsupportedEncodingException {
        return EmailUtils.newAddress(address, null, null);
    }

    public static EmailMessage setFromToEmailMessage(String senderEmail, String senderPersonal, String senderCharset, EmailMessage emailMessage) {
        Address senderAddress = null;
        try {
            senderAddress = EmailUtils.newAddress(senderEmail, senderPersonal, senderCharset);
        }
        catch (AddressException e2) {
            logger.error((Object)("AddressException when tryin to create the sender Address:" + senderEmail), (Throwable)e2);
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e2) {
            logger.error((Object)("UnsupportedEncodingException when tryin to create the sender Address:" + senderEmail), (Throwable)e2);
            e2.printStackTrace();
        }
        if (null != senderAddress) {
            try {
                emailMessage.setFrom(senderAddress);
            }
            catch (MessagingException e) {
                try {
                    emailMessage.setFrom(senderEmail);
                }
                catch (AddressException e1) {
                    logger.error((Object)("AddressException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                    e1.printStackTrace();
                }
                catch (UnsupportedEncodingException e1) {
                    logger.error((Object)("UnsupportedEncodingException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                    e1.printStackTrace();
                }
                catch (MessagingException e1) {
                    logger.error((Object)("MessagingException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            try {
                emailMessage.setFrom(senderEmail);
            }
            catch (AddressException e1) {
                logger.error((Object)("AddressException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                e1.printStackTrace();
            }
            catch (UnsupportedEncodingException e1) {
                logger.error((Object)("UnsupportedEncodingException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                e1.printStackTrace();
            }
            catch (MessagingException e1) {
                logger.error((Object)("MessagingException when tryin to set the From Address:" + senderEmail), (Throwable)e1);
                e1.printStackTrace();
            }
        }
        return emailMessage;
    }

    public static EmailMessage addToRecipientToEmailMessage(String recipientEmail, String recipientPersonal, String recipientCharset, EmailMessage emailMessage) {
        Address recipientAddress = null;
        try {
            recipientAddress = EmailUtils.newAddress(recipientEmail, recipientPersonal, recipientCharset);
        }
        catch (AddressException e2) {
            logger.error((Object)("AddressException when tryin to create the recipient Address:" + recipientEmail), (Throwable)e2);
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e2) {
            logger.error((Object)("UnsupportedEncodingException when tryin to create the recipient Address:" + recipientEmail), (Throwable)e2);
            e2.printStackTrace();
        }
        if (null != recipientAddress) {
            try {
                emailMessage.addTo(recipientAddress);
            }
            catch (MessagingException e) {
                try {
                    emailMessage.setRecipients(Message.RecipientType.TO, recipientEmail);
                }
                catch (AddressException e1) {
                    logger.error((Object)("AddressException when tryin to set the To Address:" + recipientEmail), (Throwable)e1);
                    e1.printStackTrace();
                }
                catch (MessagingException e1) {
                    logger.error((Object)("MessagingException when tryin to set the To Address:" + recipientEmail), (Throwable)e1);
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            try {
                emailMessage.setRecipients(Message.RecipientType.TO, recipientEmail);
            }
            catch (AddressException e1) {
                logger.error((Object)("AddressException when tryin to set the To Address:" + recipientEmail), (Throwable)e1);
                e1.printStackTrace();
            }
            catch (MessagingException e1) {
                logger.error((Object)("MessagingException when tryin to set the To Address:" + recipientEmail), (Throwable)e1);
                e1.printStackTrace();
            }
        }
        return emailMessage;
    }
}

