/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.email.send;

import java.io.UnsupportedEncodingException;
import java.util.Collection;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

import net.sourceforge.jaulp.email.messages.EmailMessage;
import net.sourceforge.jaulp.email.messages.EmailMessageWithAttachments;

/**
 * The Interface SendMail.
 */
public interface SendMail
{

	/**
	 * Checks the debug flag if it is true or false.
	 *
	 * @return true, if the debug flag is true otherwise false.
	 */
	boolean isDebug();

	/**
	 * Sends the EmailMessage thats wrappes from the EmailMessagWithAttachments.
	 *
	 * @param emailAttachments
	 *            The EmailAttachments who wrappes the EmailMessage.
	 *
	 * @return 's the messageid.
	 *
	 * @throws MessagingException
	 *             if an error occurs.
	 */
	String sendEmailMessageWithAttachments(final EmailMessageWithAttachments emailAttachments)
		throws MessagingException;

	/**
	 * Send email messages with atachments.
	 *
	 * @param emailAttachments
	 *            the email attachments
	 * @return the collection
	 * @throws MessagingException
	 *             if an error occurs.
	 */
	Collection<String> sendEmailMessagesWithAtachments(
		final Collection<EmailMessageWithAttachments> emailAttachments) throws MessagingException;

	/**
	 * Sends the given EmailMessage.
	 *
	 * @param emailMessage
	 *            The EmailMessage to send.
	 *
	 * @return 's the messageid.
	 *
	 * @throws MessagingException
	 *             if an error occurs.
	 */
	String sendEmailMessage(final EmailMessage emailMessage) throws MessagingException;

	/**
	 * Send email messages.
	 *
	 * @param emailMessages
	 *            the email messages
	 * @return the collection
	 * @throws MessagingException
	 *             the messaging exception
	 */
	Collection<String> sendEmailMessages(final Collection<EmailMessage> emailMessages)
		throws MessagingException;

	/**
	 * Sends a simple plain text email.
	 *
	 * @param to
	 *            The to Address.
	 * @param from
	 *            The from Address.
	 * @param subject
	 *            The subject from the email.
	 * @param message
	 *            The Message from the email.
	 * @return 's the messageid.
	 * @throws AddressException
	 *             the address exception
	 * @throws UnsupportedEncodingException
	 *             if an error occurs by encoding.
	 * @throws MessagingException
	 *             if an error occurs by sending the message.
	 */
	String sendEmail(final String to, final String from, final String subject, final String message)
		throws AddressException, UnsupportedEncodingException, MessagingException;

	/**
	 * Sets the debug flag.
	 *
	 * @param debug
	 *            The debug flag to set.
	 */
	void setDebug(final boolean debug);

}