/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.designpattern.observer.event;

import de.alpharogroup.designpattern.observer.event.EventListener;
import de.alpharogroup.designpattern.observer.event.EventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventSubject<T>
implements EventSource<T> {
    private List<EventListener<T>> eventListeners = new ArrayList<EventListener<T>>();
    private T source;

    public EventSubject() {
    }

    public EventSubject(T source) {
        this.source = source;
    }

    @Override
    public synchronized void addEventListener(EventListener<T> eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public synchronized void addEventListeners(Collection<EventListener<T>> eventListeners) {
        this.eventListeners.addAll(eventListeners);
    }

    private synchronized void fireEvent() {
        for (EventListener<T> eventListener : this.eventListeners) {
            eventListener.onEvent(this.source);
        }
    }

    @Override
    public synchronized void fireEvent(T source) {
        this.source = source;
        this.fireEvent();
    }

    @Override
    public synchronized void removeEventListener(EventListener<T> eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public synchronized void removeEventListeners(Collection<EventListener<T>> eventListeners) {
        this.eventListeners.removeAll(eventListeners);
    }
}

