/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.designpattern.observer.chat;

import de.alpharogroup.designpattern.observer.chat.ChatRoom;
import de.alpharogroup.designpattern.observer.chat.IUser;
import de.alpharogroup.designpattern.observer.chat.Message;
import de.alpharogroup.designpattern.observer.ifaces.DisplayViewElement;
import de.alpharogroup.designpattern.observer.ifaces.Observer;
import java.io.Serializable;

public abstract class ChatRoomUser<M extends Message<?>>
implements Observer<M>,
DisplayViewElement,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ChatRoom<M> subject;
    private M observable;
    private final IUser<?> user;

    public ChatRoomUser(ChatRoom<M> room, IUser<?> user) {
        this.subject = room;
        this.observable = this.subject.getObservable();
        this.user = user;
        this.subject.addObserver(this);
    }

    public IUser<?> getUser() {
        return this.user;
    }

    public void send(M message) {
        this.subject.setObservable(message);
    }

    public synchronized M getObservable() {
        return this.observable;
    }

    @Override
    public synchronized void update(M observable) {
        this.observable = observable;
        this.displayView();
    }
}

