/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.designpattern.observer.chat;

import de.alpharogroup.designpattern.observer.AbstractSubject;
import de.alpharogroup.designpattern.observer.chat.ChatRoomUser;
import de.alpharogroup.designpattern.observer.chat.IUser;
import de.alpharogroup.designpattern.observer.chat.Message;
import de.alpharogroup.designpattern.observer.chat.Room;
import de.alpharogroup.designpattern.observer.ifaces.Subject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatRoom<M extends Message<?>>
extends AbstractSubject<M, ChatRoomUser<M>>
implements Subject<M, ChatRoomUser<M>>,
Room<M>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ChatRoomUser<M>> observers = new ArrayList<ChatRoomUser<M>>();
    private final List<M> messageHistory = new ArrayList<M>();
    private M observable;
    private final String name;

    public String getName() {
        return this.name;
    }

    public ChatRoom(String name) {
        this.name = name;
    }

    public ChatRoom(M observable, String name) {
        this.observable = observable;
        this.name = name;
    }

    @Override
    public synchronized void addObserver(ChatRoomUser<M> observer) {
        this.observers.add(observer);
    }

    @Override
    public synchronized M getObservable() {
        return this.observable;
    }

    @Override
    public synchronized void removeObserver(ChatRoomUser<M> observer) {
        int index = this.observers.indexOf(observer);
        if (0 <= index) {
            this.observers.remove(observer);
        }
    }

    @Override
    public synchronized void setObservable(M observable) {
        this.observable = observable;
        this.messageHistory.add(observable);
        this.updateObservers();
    }

    @Override
    public synchronized void updateObservers() {
        for (ChatRoomUser<M> observer : this.observers) {
            observer.update(this.observable);
        }
    }

    @Override
    public void addObservers(Collection<ChatRoomUser<M>> observers) {
        for (ChatRoomUser<M> chatUser : observers) {
            this.addObserver(chatUser);
        }
    }

    @Override
    public void removeObservers(Collection<ChatRoomUser<M>> observers) {
        for (ChatRoomUser<M> chatUser : observers) {
            this.removeObserver(chatUser);
        }
    }

    public int size() {
        return this.observers.size();
    }

    @Override
    public List<IUser<?>> getChatRoomUsers() {
        ArrayList chatRoomUsers = new ArrayList();
        for (ChatRoomUser<M> chatUser : this.observers) {
            chatRoomUsers.add(chatUser.getUser());
        }
        return chatRoomUsers;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public List<M> getMessageHistory() {
        return this.messageHistory;
    }
}

