/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.designpattern.observer;

import de.alpharogroup.designpattern.observer.ifaces.Observer;
import de.alpharogroup.designpattern.observer.ifaces.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSubject<T, O extends Observer<T>>
implements Subject<T, O> {
    private final List<O> observers = new ArrayList<O>();
    private T observable;

    public AbstractSubject() {
    }

    public AbstractSubject(T observable) {
        this.observable = observable;
    }

    @Override
    public synchronized void addObserver(O observer) {
        this.observers.add(observer);
    }

    @Override
    public synchronized void addObservers(Collection<O> observers) {
        this.observers.addAll(observers);
    }

    @Override
    public synchronized T getObservable() {
        return this.observable;
    }

    @Override
    public synchronized void removeObserver(O observer) {
        int index = this.observers.indexOf(observer);
        if (0 <= index) {
            this.observers.remove(observer);
        }
    }

    @Override
    public synchronized void removeObservers(Collection<O> observers) {
        this.observers.removeAll(observers);
    }

    @Override
    public synchronized void setObservable(T observable) {
        this.observable = observable;
        this.updateObservers();
    }

    @Override
    public synchronized void updateObservers() {
        Iterator<O> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            Observer observer1;
            Observer observer = observer1 = (Observer)iterator.next();
            observer.update(this.observable);
        }
    }
}

