/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.designpattern.builder;

public final class Car {
    private final String model;
    private final int constructionYear;
    private final String type;

    public static void main(String ... args) {
        Builder builder = new Builder("Lamborgini");
        Car lamborgini = builder.model("Diablo").constructionYear(2006).build();
        System.out.println(lamborgini);
    }

    private Car(Builder builder) {
        this.model = builder.model;
        this.type = builder.type;
        this.constructionYear = builder.constructionYear;
    }

    public String getModel() {
        return this.model;
    }

    public int getConstructionYear() {
        return this.constructionYear;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Car{type='" + this.type + '\'' + ", model='" + this.model + '\'' + ", constructionYear=" + this.constructionYear + '}';
    }

    public static class Builder {
        private final String type;
        private int constructionYear;
        private String model;

        public Builder(String type) {
            this.type = type;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder constructionYear(int constructionYear) {
            this.constructionYear = constructionYear;
            return this;
        }

        public Car build() {
            return new Car(this);
        }
    }
}

