/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.strategy;

/**
 * The Interface Strategy.
 *
 * @param <R>
 *            the generic return type
 * @param <M>
 *            the generic algorithm model type
 */
public interface Strategy<R, M>
{

	/**
	 * Executes the specified algorithm with the given model.
	 *
	 * @param model
	 *            generic algorithm model type.
	 * @return the generic return type.
	 */
	R execute(M model);
}